/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.api.gson.MarkerGson;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.common.BlueMapConfigProvider;
import de.bluecolored.bluemap.common.MissingResourcesException;
import de.bluecolored.bluemap.common.WebFilesManager;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.MapConfig;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.ServerInterface;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.MinecraftVersion;
import de.bluecolored.bluemap.core.debug.StateDumper;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.mca.MCAWorld;
import de.bluecolored.bluemap.core.resources.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.util.FileHelper;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.shadow.configurate.ConfigurateException;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import de.bluecolored.shadow.configurate.loader.HeaderMode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

@DebugDump
public class BlueMapService
implements Closeable {
    private final ServerInterface serverInterface;
    private final BlueMapConfigProvider configs;
    private final Map<Path, String> worldIds;
    private final Map<String, Storage> storages;
    private volatile WebFilesManager webFilesManager;
    private Map<String, World> worlds;
    private Map<String, BmMap> maps;
    private ResourcePack resourcePack;

    public BlueMapService(ServerInterface serverInterface, BlueMapConfigProvider configProvider, @Nullable ResourcePack preloadedResourcePack) {
        this(serverInterface, configProvider);
        if (preloadedResourcePack != null) {
            this.resourcePack = preloadedResourcePack;
        }
    }

    public BlueMapService(ServerInterface serverInterface, BlueMapConfigProvider configProvider) {
        this.serverInterface = serverInterface;
        this.configs = configProvider;
        this.worldIds = new ConcurrentHashMap<Path, String>();
        this.storages = new HashMap<String, Storage>();
        StateDumper.global().register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWorldId(Path worldFolder) throws IOException {
        String id = this.worldIds.get(worldFolder);
        if (id != null) {
            return id;
        }
        id = this.worldIds.get(worldFolder = worldFolder.toAbsolutePath().normalize());
        if (id != null) {
            return id;
        }
        id = this.worldIds.get(worldFolder = worldFolder.toRealPath(new LinkOption[0]));
        if (id != null) {
            return id;
        }
        Map<Path, String> map = this.worldIds;
        synchronized (map) {
            id = this.worldIds.get(worldFolder);
            if (id != null) {
                return id;
            }
            Logger.global.logDebug("Loading world id for '" + worldFolder + "'...");
            Path idFile = worldFolder.resolve("bluemap.id");
            if (!Files.exists(idFile, new LinkOption[0])) {
                id = this.serverInterface.getWorld(worldFolder).flatMap(ServerWorld::getId).orElse(UUID.randomUUID().toString());
                Files.writeString(idFile, (CharSequence)id, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                this.worldIds.put(worldFolder, id);
                return id;
            }
            id = Files.readString(idFile);
            this.worldIds.put(worldFolder, id);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebFilesManager getWebFilesManager() {
        if (this.webFilesManager == null) {
            BlueMapService blueMapService = this;
            synchronized (blueMapService) {
                if (this.webFilesManager == null) {
                    this.webFilesManager = new WebFilesManager(this.configs.getWebappConfig().getWebroot());
                }
            }
        }
        return this.webFilesManager;
    }

    public synchronized void createOrUpdateWebApp(boolean force) throws ConfigurationException {
        try {
            WebFilesManager webFilesManager = this.getWebFilesManager();
            if (force || webFilesManager.filesNeedUpdate()) {
                webFilesManager.updateFiles();
            }
            if (!this.configs.getWebappConfig().isUpdateSettingsFile()) {
                webFilesManager.loadSettings();
                webFilesManager.addFrom(this.configs.getWebappConfig());
            } else {
                webFilesManager.setFrom(this.configs.getWebappConfig());
            }
            for (String mapId : this.configs.getMapConfigs().keySet()) {
                webFilesManager.addMap(mapId);
            }
            webFilesManager.saveSettings();
        }
        catch (IOException ex) {
            throw new ConfigurationException("Failed to update web-app files!", ex);
        }
    }

    public synchronized Map<String, World> getWorlds() throws InterruptedException {
        if (this.worlds == null) {
            this.loadWorldsAndMaps();
        }
        return this.worlds;
    }

    public synchronized Map<String, BmMap> getMaps() throws InterruptedException {
        if (this.maps == null) {
            this.loadWorldsAndMaps();
        }
        return this.maps;
    }

    private synchronized void loadWorldsAndMaps() throws InterruptedException {
        this.maps = new HashMap<String, BmMap>();
        this.worlds = new HashMap<String, World>();
        for (Map.Entry<String, MapConfig> entry : this.configs.getMapConfigs().entrySet()) {
            try {
                this.loadMapConfig(entry.getKey(), entry.getValue());
            }
            catch (ConfigurationException ex) {
                Logger.global.logWarning(ex.getFormattedExplanation());
                Throwable cause = ex.getRootCause();
                if (cause == null) continue;
                Logger.global.logError("Detailed error:", ex);
            }
        }
        this.worlds = Collections.unmodifiableMap(this.worlds);
        this.maps = Collections.unmodifiableMap(this.maps);
    }

    private synchronized void loadMapConfig(String id, MapConfig mapConfig) throws ConfigurationException, InterruptedException {
        String worldId;
        Path worldFolder;
        String name = mapConfig.getName();
        if (name == null) {
            name = id;
        }
        if ((worldFolder = mapConfig.getWorld()) == null) {
            Logger.global.logInfo("The map '" + name + "' has no world configured. The map will be displayed, but not updated!");
            return;
        }
        if (!Files.isDirectory(worldFolder, new LinkOption[0])) {
            throw new ConfigurationException("'" + worldFolder.toAbsolutePath().normalize() + "' does not exist or is no directory!\nCheck if the 'world' setting in the config-file for that map is correct, or remove the entire config-file if you don't want that map.");
        }
        try {
            worldId = this.getWorldId(worldFolder);
        }
        catch (IOException ex) {
            throw new ConfigurationException("Could not load the ID for the world (" + worldFolder.toAbsolutePath().normalize() + ")!\nMake sure BlueMap has read and write access/permissions to the world-files for this map.", ex);
        }
        World world = this.worlds.get(worldId);
        if (world == null) {
            try {
                Logger.global.logInfo("Loading world '" + worldId + "' (" + worldFolder.toAbsolutePath().normalize() + ")...");
                world = new MCAWorld(worldFolder, mapConfig.getWorldSkyLight(), mapConfig.isIgnoreMissingLightData());
                this.worlds.put(worldId, world);
            }
            catch (IOException ex) {
                throw new ConfigurationException("Failed to load world '" + worldId + "' (" + worldFolder.toAbsolutePath().normalize() + ")!\nIs the level.dat of that world present and not corrupted?", ex);
            }
        }
        Storage storage = this.getStorage(mapConfig.getStorage());
        try {
            Logger.global.logInfo("Loading map '" + name + "'...");
            BmMap map = new BmMap(id, name, worldId, world, storage, this.getResourcePack(), mapConfig);
            this.maps.put(id, map);
            ConfigurationNode markerSetNode = mapConfig.getMarkerSets();
            if (markerSetNode != null && !markerSetNode.empty()) {
                String markerJson = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().headerMode(HeaderMode.NONE)).lenient(false).indent(0).buildAndSaveString(markerSetNode);
                Gson gson = MarkerGson.addAdapters(new GsonBuilder()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_DASHES).create();
                Type markerSetType = new TypeToken<Map<String, MarkerSet>>(){}.getType();
                Map markerSets = (Map)gson.fromJson(markerJson, markerSetType);
                map.getMarkerSets().putAll(markerSets);
            }
        }
        catch (JsonParseException | ConfigurateException ex) {
            throw new ConfigurationException("Failed to create the markers for map '" + id + "'!\nMake sure your marker-configuration for this map is valid.", ex);
        }
        catch (ConfigurationException | IOException ex) {
            throw new ConfigurationException("Failed to load map '" + id + "'!", ex);
        }
    }

    public synchronized Storage getStorage(String storageId) throws ConfigurationException {
        Storage storage = this.storages.get(storageId);
        if (storage == null) {
            try {
                StorageConfig storageConfig = this.getConfigs().getStorageConfigs().get(storageId);
                if (storageConfig == null) {
                    throw new ConfigurationException("There is no storage-configuration for '" + storageId + "'!\nYou will either need to define that storage, or change the map-config to use a storage-config that exists.");
                }
                Logger.global.logInfo("Initializing Storage: '" + storageId + "' (Type: " + storageConfig.getStorageType() + ")");
                storage = storageConfig.createStorage();
                storage.initialize();
            }
            catch (Exception ex) {
                ConfigurationException confEx = new ConfigurationException("Failed to load and initialize the storage '" + storageId + "'!", ex);
                if (storage != null) {
                    try {
                        storage.close();
                    }
                    catch (Exception closeEx) {
                        confEx.addSuppressed(closeEx);
                    }
                }
                throw confEx;
            }
            this.storages.put(storageId, storage);
        }
        return storage;
    }

    public synchronized ResourcePack getResourcePack() throws ConfigurationException, InterruptedException {
        if (this.resourcePack == null) {
            MinecraftVersion minecraftVersion = this.serverInterface.getMinecraftVersion();
            Path defaultResourceFile = this.configs.getCoreConfig().getData().resolve("minecraft-client-" + minecraftVersion.getResource().getVersion().getVersionString() + ".jar");
            Path resourceExtensionsFile = this.configs.getCoreConfig().getData().resolve("resourceExtensions.zip");
            Path resourcePackFolder = this.serverInterface.getConfigFolder().resolve("resourcepacks");
            try {
                FileHelper.createDirectories(resourcePackFolder, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new ConfigurationException("BlueMap failed to create this folder:\n" + resourcePackFolder + "\nDoes BlueMap has sufficient permissions?", ex);
            }
            if (!Files.exists(defaultResourceFile, new LinkOption[0])) {
                if (this.configs.getCoreConfig().isAcceptDownload()) {
                    try {
                        Logger.global.logInfo("Downloading " + minecraftVersion.getResource().getClientUrl() + " to " + defaultResourceFile + " ...");
                        FileHelper.createDirectories(defaultResourceFile.getParent(), new FileAttribute[0]);
                        Path tempResourceFile = defaultResourceFile.getParent().resolve(defaultResourceFile.getFileName() + ".filepart");
                        Files.deleteIfExists(tempResourceFile);
                        FileUtils.copyURLToFile((URL)new URL(minecraftVersion.getResource().getClientUrl()), (File)tempResourceFile.toFile(), (int)10000, (int)10000);
                        FileHelper.move(tempResourceFile, defaultResourceFile);
                    }
                    catch (IOException ex) {
                        throw new ConfigurationException("Failed to download resources!", ex);
                    }
                } else {
                    throw new MissingResourcesException();
                }
            }
            try {
                Files.deleteIfExists(resourceExtensionsFile);
                FileHelper.createDirectories(resourceExtensionsFile.getParent(), new FileAttribute[0]);
                URL resourceExtensionsUrl = Objects.requireNonNull(Plugin.class.getResource("/de/bluecolored/bluemap/" + minecraftVersion.getResource().getResourcePrefix() + "/resourceExtensions.zip"));
                FileUtils.copyURLToFile((URL)resourceExtensionsUrl, (File)resourceExtensionsFile.toFile(), (int)10000, (int)10000);
            }
            catch (IOException ex) {
                throw new ConfigurationException("Failed to create resourceExtensions.zip!\nDoes BlueMap has sufficient write permissions?", ex);
            }
            try {
                this.resourcePack = new ResourcePack();
                ArrayList<Path> resourcePackRoots = new ArrayList<Path>();
                try (Stream<Path> resourcepackFiles = Files.list(resourcePackFolder);){
                    resourcepackFiles.sorted(Comparator.reverseOrder()).forEach(resourcePackRoots::add);
                }
                if (this.configs.getCoreConfig().isScanForModResources()) {
                    Path modsFolder = this.serverInterface.getModsFolder().orElse(null);
                    if (modsFolder != null && Files.isDirectory(modsFolder, new LinkOption[0])) {
                        try (Stream<Path> resourcepackFiles = Files.list(modsFolder);){
                            resourcepackFiles.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.getFileName().toString().endsWith(".jar")).forEach(resourcePackRoots::add);
                        }
                    }
                    for (Path worldFolder : this.getWorldFolders()) {
                        Path datapacksFolder = worldFolder.resolve("datapacks");
                        if (!Files.isDirectory(datapacksFolder, new LinkOption[0])) continue;
                        Stream<Path> resourcepackFiles = Files.list(worldFolder.resolve("datapacks"));
                        try {
                            resourcepackFiles.forEach(resourcePackRoots::add);
                        }
                        finally {
                            if (resourcepackFiles == null) continue;
                            resourcepackFiles.close();
                        }
                    }
                }
                resourcePackRoots.add(resourceExtensionsFile);
                resourcePackRoots.add(defaultResourceFile);
                this.resourcePack.loadResources(resourcePackRoots);
            }
            catch (IOException | RuntimeException e) {
                throw new ConfigurationException("Failed to parse resources!\nIs one of your resource-packs corrupted?", e);
            }
        }
        return this.resourcePack;
    }

    public Optional<ResourcePack> getResourcePackIfLoaded() {
        return Optional.ofNullable(this.resourcePack);
    }

    private Collection<Path> getWorldFolders() {
        HashSet<Path> folders = new HashSet<Path>();
        for (MapConfig mapConfig : this.configs.getMapConfigs().values()) {
            Path folder = mapConfig.getWorld();
            if (folder == null || !Files.isDirectory(folder = folder.toAbsolutePath().normalize(), new LinkOption[0])) continue;
            folders.add(folder);
        }
        return folders;
    }

    public BlueMapConfigProvider getConfigs() {
        return this.configs;
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        for (Storage storage : this.storages.values()) {
            try {
                if (storage == null) continue;
                storage.close();
            }
            catch (IOException ex) {
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                exception.addSuppressed(ex);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

