/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common;

import com.google.gson.GsonBuilder;
import de.bluecolored.bluemap.common.config.WebappConfig;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.util.FileHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;

public class WebFilesManager {
    private final Path webRoot;
    private Settings settings;

    public WebFilesManager(Path webRoot) {
        this.webRoot = webRoot;
        this.settings = new Settings();
    }

    public Path getSettingsFile() {
        return this.webRoot.resolve("settings.json");
    }

    public void loadSettings() throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(this.getSettingsFile());){
            this.settings = (Settings)ResourcesGson.INSTANCE.fromJson((Reader)reader, Settings.class);
        }
    }

    public void saveSettings() throws IOException {
        FileHelper.createDirectories(this.getSettingsFile().getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(this.getSettingsFile(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            ResourcesGson.addAdapter(new GsonBuilder()).setPrettyPrinting().create().toJson((Object)this.settings, (Appendable)writer);
        }
    }

    public void resetSettings() {
        this.settings = new Settings();
    }

    public void addMap(String mapId) {
        this.settings.maps.add(mapId);
    }

    public void removeMap(String mapId) {
        this.settings.maps.remove(mapId);
    }

    public Set<String> getScripts() {
        return this.settings.scripts;
    }

    public Set<String> getStyles() {
        return this.settings.styles;
    }

    public void setFrom(WebappConfig webappConfig) {
        this.settings.setFrom(webappConfig);
    }

    public void addFrom(WebappConfig webappConfig) {
        this.settings.addFrom(webappConfig);
    }

    public boolean filesNeedUpdate() {
        return !Files.exists(this.webRoot.resolve("index.html"), new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFiles() throws IOException {
        URL fileResource = this.getClass().getResource("/de/bluecolored/bluemap/webapp.zip");
        File tempFile = File.createTempFile("bluemap_webroot_extraction", null);
        if (fileResource == null) {
            throw new IOException("Failed to open bundled webapp.");
        }
        try {
            FileUtils.copyURLToFile((URL)fileResource, (File)tempFile, (int)10000, (int)10000);
            try (ZipFile zipFile = new ZipFile(tempFile);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    if (zipEntry.isDirectory()) {
                        File dir = this.webRoot.resolve(zipEntry.getName()).toFile();
                        FileUtils.forceMkdir((File)dir);
                        continue;
                    }
                    File target = this.webRoot.resolve(zipEntry.getName()).toFile();
                    FileUtils.forceMkdirParent((File)target);
                    FileUtils.copyInputStreamToFile((InputStream)zipFile.getInputStream(zipEntry), (File)target);
                }
            }
            Path indexFile = this.webRoot.resolve("index.html");
            String indexContent = Files.readString(indexFile);
            indexContent = indexContent.replace("%version%", BlueMap.VERSION);
            Files.writeString(indexFile, (CharSequence)indexContent, new OpenOption[0]);
        }
        finally {
            if (!tempFile.delete()) {
                Logger.global.logWarning("Failed to delete file: " + tempFile);
            }
        }
    }

    private static class Settings {
        private String version = BlueMap.VERSION;
        private boolean useCookies = true;
        private boolean enableFreeFlight = true;
        private boolean defaultToFlatView = false;
        private String startLocation = null;
        private float resolutionDefault = 1.0f;
        private int minZoomDistance = 5;
        private int maxZoomDistance = 100000;
        private int hiresSliderMax = 500;
        private int hiresSliderDefault = 200;
        private int hiresSliderMin = 50;
        private int lowresSliderMax = 10000;
        private int lowresSliderDefault = 2000;
        private int lowresSliderMin = 500;
        private Set<String> maps = new HashSet<String>();
        private Set<String> scripts = new HashSet<String>();
        private Set<String> styles = new HashSet<String>();

        private Settings() {
        }

        public void setFrom(WebappConfig config) {
            this.useCookies = config.isUseCookies();
            this.enableFreeFlight = config.isEnableFreeFlight();
            this.defaultToFlatView = config.isDefaultToFlatView();
            this.startLocation = config.getStartLocation().orElse(null);
            this.resolutionDefault = config.getResolutionDefault();
            this.minZoomDistance = config.getMinZoomDistance();
            this.maxZoomDistance = config.getMaxZoomDistance();
            this.hiresSliderMax = config.getHiresSliderMax();
            this.hiresSliderDefault = config.getHiresSliderDefault();
            this.hiresSliderMin = config.getHiresSliderMin();
            this.lowresSliderMax = config.getLowresSliderMax();
            this.lowresSliderDefault = config.getLowresSliderDefault();
            this.lowresSliderMin = config.getLowresSliderMin();
            this.styles.clear();
            this.scripts.clear();
            this.addFrom(config);
        }

        public void addFrom(WebappConfig config) {
            this.scripts.addAll(config.getScripts());
            this.styles.addAll(config.getStyles());
        }
    }
}

