/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import de.bluecolored.bluemap.api.AssetStorage;
import de.bluecolored.bluemap.core.storage.Storage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;

public class AssetStorageImpl
implements AssetStorage {
    private static final String ASSET_PATH = "assets/";
    private final Storage storage;
    private final String mapId;

    public AssetStorageImpl(Storage storage, String mapId) {
        this.storage = storage;
        this.mapId = mapId;
    }

    @Override
    public OutputStream writeAsset(String name) throws IOException {
        return this.storage.writeMeta(this.mapId, ASSET_PATH + name);
    }

    @Override
    public Optional<InputStream> readAsset(String name) throws IOException {
        return this.storage.readMeta(this.mapId, ASSET_PATH + name);
    }

    @Override
    public boolean assetExists(String name) throws IOException {
        return this.storage.readMetaInfo(this.mapId, ASSET_PATH + name).isPresent();
    }

    @Override
    public String getAssetUrl(String name) {
        return "maps/" + this.mapId + "/" + Storage.escapeMetaName(ASSET_PATH + name);
    }

    @Override
    public void deleteAsset(String name) throws IOException {
        this.storage.deleteMeta(this.mapId, ASSET_PATH + name);
    }
}

