/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.common.api.BlueMapMapImpl;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.world.World;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class BlueMapWorldImpl
implements BlueMapWorld {
    private final WeakReference<Plugin> plugin;
    private final String id;
    private final WeakReference<World> world;

    public BlueMapWorldImpl(Plugin plugin, World world) throws IOException {
        this.plugin = new WeakReference<Plugin>(plugin);
        this.id = plugin.getBlueMap().getWorldId(world.getSaveFolder());
        this.world = new WeakReference<World>(world);
    }

    public World getWorld() {
        return this.unpack(this.world);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Path getSaveFolder() {
        return this.unpack(this.world).getSaveFolder();
    }

    @Override
    public Collection<BlueMapMap> getMaps() {
        return this.unpack(this.plugin).getMaps().values().stream().filter(map -> map.getWorld().equals(this.unpack(this.world))).map(map -> new BlueMapMapImpl(this.unpack(this.plugin), (BmMap)map, this)).collect(Collectors.toUnmodifiableSet());
    }

    private <T> T unpack(WeakReference<T> ref) {
        return Objects.requireNonNull(ref.get(), "Reference lost to delegate object. Most likely BlueMap got reloaded and this instance is no longer valid.");
    }
}

