/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.common.BlueMapConfigProvider;
import de.bluecolored.bluemap.common.config.ConfigManager;
import de.bluecolored.bluemap.common.config.ConfigTemplate;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.CoreConfig;
import de.bluecolored.bluemap.common.config.MapConfig;
import de.bluecolored.bluemap.common.config.PluginConfig;
import de.bluecolored.bluemap.common.config.WebappConfig;
import de.bluecolored.bluemap.common.config.WebserverConfig;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.common.serverinterface.ServerInterface;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.FileHelper;
import de.bluecolored.bluemap.core.util.Tristate;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;

@DebugDump
public class BlueMapConfigs
implements BlueMapConfigProvider {
    private final ServerInterface serverInterface;
    private final ConfigManager configManager;
    private final CoreConfig coreConfig;
    private final WebserverConfig webserverConfig;
    private final WebappConfig webappConfig;
    private final PluginConfig pluginConfig;
    private final Map<String, MapConfig> mapConfigs;
    private final Map<String, StorageConfig> storageConfigs;

    public BlueMapConfigs(ServerInterface serverInterface) throws ConfigurationException {
        this(serverInterface, Path.of("bluemap", new String[0]), Path.of("bluemap", "web"), true);
    }

    public BlueMapConfigs(ServerInterface serverInterface, Path defaultDataFolder, Path defaultWebroot, boolean usePluginConf) throws ConfigurationException {
        this.serverInterface = serverInterface;
        this.configManager = new ConfigManager(serverInterface.getConfigFolder());
        this.coreConfig = this.loadCoreConfig(defaultDataFolder);
        this.webappConfig = this.loadWebappConfig(defaultWebroot);
        this.webserverConfig = this.loadWebserverConfig(this.webappConfig.getWebroot(), this.coreConfig.getData());
        this.pluginConfig = usePluginConf ? this.loadPluginConfig() : new PluginConfig();
        this.storageConfigs = Collections.unmodifiableMap(this.loadStorageConfigs(this.webappConfig.getWebroot()));
        this.mapConfigs = Collections.unmodifiableMap(this.loadMapConfigs());
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public CoreConfig getCoreConfig() {
        return this.coreConfig;
    }

    @Override
    public WebappConfig getWebappConfig() {
        return this.webappConfig;
    }

    @Override
    public WebserverConfig getWebserverConfig() {
        return this.webserverConfig;
    }

    @Override
    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    @Override
    public Map<String, MapConfig> getMapConfigs() {
        return this.mapConfigs;
    }

    @Override
    public Map<String, StorageConfig> getStorageConfigs() {
        return this.storageConfigs;
    }

    private synchronized CoreConfig loadCoreConfig(Path defaultDataFolder) throws ConfigurationException {
        Path configFileRaw = Path.of("core", new String[0]);
        Path configFile = this.configManager.findConfigPath(configFileRaw);
        Path configFolder = configFile.getParent();
        if (!Files.exists(configFile, new LinkOption[0])) {
            Runtime runtime = Runtime.getRuntime();
            int availableCores = runtime.availableProcessors();
            long availableMemoryMiB = runtime.maxMemory() / 1024L / 1024L;
            int presetRenderThreadCount = 1;
            if (availableCores >= 6 && availableMemoryMiB >= 4096L) {
                presetRenderThreadCount = 2;
            }
            if (availableCores >= 10 && availableMemoryMiB >= 8192L) {
                presetRenderThreadCount = 3;
            }
            try {
                FileHelper.createDirectories(configFolder, new FileAttribute[0]);
                Files.writeString(configFolder.resolve("core.conf"), (CharSequence)this.configManager.loadConfigTemplate("/de/bluecolored/bluemap/config/core.conf").setConditional("metrics", this.serverInterface.isMetricsEnabled() == Tristate.UNDEFINED).setVariable("timestamp", LocalDateTime.now().withNano(0).toString()).setVariable("version", BlueMap.VERSION).setVariable("data", this.formatPath(defaultDataFolder)).setVariable("implementation", "bukkit").setVariable("render-thread-count", Integer.toString(presetRenderThreadCount)).setVariable("logfile", this.formatPath(defaultDataFolder.resolve("logs").resolve("debug.log"))).setVariable("logfile-with-time", this.formatPath(defaultDataFolder.resolve("logs").resolve("debug_%1$tF_%1$tT.log"))).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException | NullPointerException ex) {
                Logger.global.logWarning("Failed to create default core-configuration-file: " + ex);
            }
        }
        return this.configManager.loadConfig(configFileRaw, CoreConfig.class);
    }

    private synchronized WebserverConfig loadWebserverConfig(Path defaultWebroot, Path dataRoot) throws ConfigurationException {
        Path configFileRaw = Path.of("webserver", new String[0]);
        Path configFile = this.configManager.findConfigPath(configFileRaw);
        Path configFolder = configFile.getParent();
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                FileHelper.createDirectories(configFolder, new FileAttribute[0]);
                Files.writeString(configFolder.resolve("webserver.conf"), (CharSequence)this.configManager.loadConfigTemplate("/de/bluecolored/bluemap/config/webserver.conf").setVariable("webroot", this.formatPath(defaultWebroot)).setVariable("logfile", this.formatPath(dataRoot.resolve("logs").resolve("webserver.log"))).setVariable("logfile-with-time", this.formatPath(dataRoot.resolve("logs").resolve("webserver_%1$tF_%1$tT.log"))).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException | NullPointerException ex) {
                Logger.global.logWarning("Failed to create default webserver-configuration-file: " + ex);
            }
        }
        return this.configManager.loadConfig(configFileRaw, WebserverConfig.class);
    }

    private synchronized WebappConfig loadWebappConfig(Path defaultWebroot) throws ConfigurationException {
        Path configFileRaw = Path.of("webapp", new String[0]);
        Path configFile = this.configManager.findConfigPath(configFileRaw);
        Path configFolder = configFile.getParent();
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                FileHelper.createDirectories(configFolder, new FileAttribute[0]);
                Files.writeString(configFolder.resolve("webapp.conf"), (CharSequence)this.configManager.loadConfigTemplate("/de/bluecolored/bluemap/config/webapp.conf").setVariable("webroot", this.formatPath(defaultWebroot)).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException | NullPointerException ex) {
                Logger.global.logWarning("Failed to create default webapp-configuration-file: " + ex);
            }
        }
        return this.configManager.loadConfig(configFileRaw, WebappConfig.class);
    }

    private synchronized PluginConfig loadPluginConfig() throws ConfigurationException {
        Path configFileRaw = Path.of("plugin", new String[0]);
        Path configFile = this.configManager.findConfigPath(configFileRaw);
        Path configFolder = configFile.getParent();
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                FileHelper.createDirectories(configFolder, new FileAttribute[0]);
                Files.writeString(configFolder.resolve("plugin.conf"), (CharSequence)this.configManager.loadConfigTemplate("/de/bluecolored/bluemap/config/plugin.conf").build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException | NullPointerException ex) {
                Logger.global.logWarning("Failed to create default webapp-configuration-file: " + ex);
            }
        }
        return this.configManager.loadConfig(configFileRaw, PluginConfig.class);
    }

    private synchronized Map<String, MapConfig> loadMapConfigs() throws ConfigurationException {
        HashMap<String, MapConfig> mapConfigs = new HashMap<String, MapConfig>();
        Path mapFolder = Paths.get("maps", new String[0]);
        Path mapConfigFolder = this.configManager.getConfigRoot().resolve(mapFolder);
        if (!Files.exists(mapConfigFolder, new LinkOption[0])) {
            try {
                FileHelper.createDirectories(mapConfigFolder, new FileAttribute[0]);
                Collection<ServerWorld> worlds = this.serverInterface.getLoadedWorlds();
                if (worlds.isEmpty()) {
                    Files.writeString(mapConfigFolder.resolve("overworld.conf"), (CharSequence)this.createOverworldMapTemplate("Overworld", Path.of("world", new String[0]), 0).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    Files.writeString(mapConfigFolder.resolve("nether.conf"), (CharSequence)this.createNetherMapTemplate("Nether", Path.of("world", "DIM-1"), 0).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    Files.writeString(mapConfigFolder.resolve("end.conf"), (CharSequence)this.createEndMapTemplate("End", Path.of("world", "DIM1"), 0).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                } else {
                    for (ServerWorld world : worlds) {
                        ConfigTemplate template;
                        Object name = world.getName().orElse(world.getDimension().getName());
                        Path worldFolder = world.getSaveFolder();
                        Path configFile = mapConfigFolder.resolve(this.sanitiseMapId(((String)name).toLowerCase(Locale.ROOT)) + ".conf");
                        int i = 1;
                        while (Files.exists(configFile, new LinkOption[0])) {
                            configFile = mapConfigFolder.resolve(this.sanitiseMapId(((String)name).toLowerCase(Locale.ROOT)) + "_" + ++i + ".conf");
                        }
                        if (i > 1) {
                            name = (String)name + " " + i;
                        }
                        switch (world.getDimension()) {
                            case NETHER: {
                                template = this.createNetherMapTemplate((String)name, worldFolder, i - 1);
                                break;
                            }
                            case END: {
                                template = this.createEndMapTemplate((String)name, worldFolder, i - 1);
                                break;
                            }
                            default: {
                                template = this.createOverworldMapTemplate((String)name, worldFolder, i - 1);
                            }
                        }
                        Files.writeString(configFile, (CharSequence)template.build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    }
                }
            }
            catch (IOException | NullPointerException ex) {
                throw new ConfigurationException("BlueMap failed to create default map-configuration-files in\n" + mapConfigFolder.toAbsolutePath().normalize() + "\nCheck if BlueMap has the permission to create and read from this folder.", ex);
            }
        }
        try (Stream<Path> configFiles = Files.list(mapConfigFolder);){
            for (Path configFile : (Path[])configFiles.toArray(Path[]::new)) {
                if (!this.configManager.isConfigFile(configFile)) continue;
                Path rawConfig = this.configManager.getRaw(configFile);
                String id = this.sanitiseMapId(rawConfig.getFileName().toString());
                if (mapConfigs.containsKey(id)) {
                    throw new ConfigurationException("At least two of your map-config file-names result in ambiguous map-id's!\n" + configFile.toAbsolutePath().normalize() + "\nTo resolve this issue, rename this file to something else.");
                }
                MapConfig mapConfig = this.configManager.loadConfig(rawConfig, MapConfig.class);
                mapConfigs.put(id, mapConfig);
            }
        }
        catch (IOException ex) {
            throw new ConfigurationException("BlueMap failed to read your map configuration from\n" + mapConfigFolder.toAbsolutePath().normalize() + "\nCheck if BlueMap has the permission to create and read from this folder.", ex);
        }
        return mapConfigs;
    }

    private synchronized Map<String, StorageConfig> loadStorageConfigs(Path defaultWebroot) throws ConfigurationException {
        HashMap<String, StorageConfig> storageConfigs = new HashMap<String, StorageConfig>();
        Path storageFolder = Paths.get("storages", new String[0]);
        Path storageConfigFolder = this.configManager.getConfigRoot().resolve(storageFolder);
        if (!Files.exists(storageConfigFolder, new LinkOption[0])) {
            try {
                FileHelper.createDirectories(storageConfigFolder, new FileAttribute[0]);
                Files.writeString(storageConfigFolder.resolve("file.conf"), (CharSequence)this.configManager.loadConfigTemplate("/de/bluecolored/bluemap/config/storages/file.conf").setVariable("root", this.formatPath(defaultWebroot.resolve("maps"))).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                Files.writeString(storageConfigFolder.resolve("sql.conf"), (CharSequence)this.configManager.loadConfigTemplate("/de/bluecolored/bluemap/config/storages/sql.conf").build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException | NullPointerException ex) {
                throw new ConfigurationException("BlueMap failed to create default storage-configuration-files in\n" + storageConfigFolder.toAbsolutePath().normalize() + "\nCheck if BlueMap has the permission to create and read from this folder.", ex);
            }
        }
        try (Stream<Path> configFiles = Files.list(storageConfigFolder);){
            for (Path configFile : (Path[])configFiles.toArray(Path[]::new)) {
                if (!this.configManager.isConfigFile(configFile)) continue;
                Path rawConfig = this.configManager.getRaw(configFile);
                String id = rawConfig.getFileName().toString();
                StorageConfig storageConfig = this.configManager.loadConfig(rawConfig, StorageConfig.class);
                storageConfig = this.configManager.loadConfig(rawConfig, storageConfig.getStorageType().getConfigType());
                storageConfigs.put(id, storageConfig);
            }
        }
        catch (IOException ex) {
            throw new ConfigurationException("BlueMap failed to read your map configuration from\n" + storageConfigFolder.toAbsolutePath().normalize() + "\nCheck if BlueMap has the permission to create and read from this folder.", ex);
        }
        return storageConfigs;
    }

    private String sanitiseMapId(String id) {
        return id.replaceAll("\\W", "_");
    }

    private ConfigTemplate createOverworldMapTemplate(String name, Path worldFolder, int index) throws IOException {
        return this.configManager.loadConfigTemplate("/de/bluecolored/bluemap/config/maps/map.conf").setVariable("name", name).setVariable("sorting", "" + index).setVariable("world", this.formatPath(worldFolder)).setVariable("sky-color", "#7dabff").setVariable("void-color", "#000000").setVariable("ambient-light", "0.1").setVariable("world-sky-light", "15").setVariable("remove-caves-below-y", "55").setConditional("max-y-comment", true).setVariable("max-y", "100");
    }

    private ConfigTemplate createNetherMapTemplate(String name, Path worldFolder, int index) throws IOException {
        return this.configManager.loadConfigTemplate("/de/bluecolored/bluemap/config/maps/map.conf").setVariable("name", name).setVariable("sorting", "" + (100 + index)).setVariable("world", this.formatPath(worldFolder)).setVariable("sky-color", "#290000").setVariable("void-color", "#150000").setVariable("ambient-light", "0.6").setVariable("world-sky-light", "0").setVariable("remove-caves-below-y", "-10000").setConditional("max-y-comment", false).setVariable("max-y", "90");
    }

    private ConfigTemplate createEndMapTemplate(String name, Path worldFolder, int index) throws IOException {
        return this.configManager.loadConfigTemplate("/de/bluecolored/bluemap/config/maps/map.conf").setVariable("name", name).setVariable("sorting", "" + (200 + index)).setVariable("world", this.formatPath(worldFolder)).setVariable("sky-color", "#080010").setVariable("void-color", "#080010").setVariable("ambient-light", "0.6").setVariable("world-sky-light", "0").setVariable("remove-caves-below-y", "-10000").setConditional("max-y-comment", true).setVariable("max-y", "100");
    }

    private String formatPath(Path path) {
        String pathString;
        path = Path.of("", new String[0]).toAbsolutePath().relativize(path.toAbsolutePath()).normalize();
        String formatted = pathString = path.toString();
        String separator = FileSystems.getDefault().getSeparator();
        if (!separator.equals("/")) {
            formatted = pathString.replace(separator, "/");
        }
        if (!Path.of(formatted, new String[0]).equals(path)) {
            formatted = pathString;
        }
        formatted = formatted.replace("\\", "\\\\");
        return formatted;
    }
}

