/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.storage;

import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.core.storage.Compression;
import de.bluecolored.bluemap.core.storage.sql.SQLStorageSettings;
import de.bluecolored.shadow.configurate.objectmapping.ConfigSerializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ConfigSerializable
public class SQLConfig
extends StorageConfig
implements SQLStorageSettings {
    @DebugDump
    private String driverJar = null;
    @DebugDump
    private String driverClass = null;
    private String connectionUrl = "jdbc:mysql://localhost/bluemap?permitMysqlScheme";
    private Map<String, String> connectionProperties = new HashMap<String, String>();
    @DebugDump
    private Compression compression = Compression.GZIP;
    @DebugDump
    private transient URL driverJarURL = null;
    @DebugDump
    private int maxConnections = -1;

    @Override
    public Optional<URL> getDriverJar() throws MalformedURLException {
        if (this.driverJar == null) {
            return Optional.empty();
        }
        if (this.driverJarURL == null) {
            this.driverJarURL = Paths.get(this.driverJar, new String[0]).toUri().toURL();
        }
        return Optional.of(this.driverJarURL);
    }

    @Override
    public Optional<String> getDriverClass() {
        return Optional.ofNullable(this.driverClass);
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public Compression getCompression() {
        return this.compression;
    }
}

