/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.live;

import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.common.config.PluginConfig;
import de.bluecolored.bluemap.common.serverinterface.Player;
import de.bluecolored.bluemap.common.serverinterface.ServerInterface;
import de.bluecolored.bluemap.core.logger.Logger;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class LivePlayersDataSupplier
implements Supplier<String> {
    private final ServerInterface server;
    private final PluginConfig config;
    @Nullable
    private final String worldId;
    private final Predicate<UUID> playerFilter;

    public LivePlayersDataSupplier(ServerInterface server, PluginConfig config, @Nullable String worldId, Predicate<UUID> playerFilter) {
        this.server = server;
        this.config = config;
        this.worldId = worldId;
        this.playerFilter = playerFilter;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String get() {
        try (StringWriter jsonString = new StringWriter();){
            String string;
            try (JsonWriter json = new JsonWriter((Writer)jsonString);){
                json.beginObject();
                json.name("players").beginArray();
                if (this.config.isLivePlayerMarkers()) {
                    for (Player player : this.server.getOnlinePlayers()) {
                        if (!player.isOnline()) continue;
                        boolean isCorrectWorld = player.getWorld().equals(this.worldId);
                        if (this.config.isHideInvisible() && player.isInvisible() || this.config.isHideVanished() && player.isVanished() || this.config.isHideSneaking() && player.isSneaking() || this.config.getHiddenGameModes().contains(player.getGamemode().getId()) || this.config.isHideDifferentWorld() && !isCorrectWorld || player.getSkyLight() < this.config.getHideBelowSkyLight() && player.getBlockLight() < this.config.getHideBelowBlockLight() || !this.playerFilter.test(player.getUuid())) continue;
                        json.beginObject();
                        json.name("uuid").value(player.getUuid().toString());
                        json.name("name").value(player.getName().toPlainString());
                        json.name("foreign").value(!isCorrectWorld);
                        json.name("position").beginObject();
                        json.name("x").value(player.getPosition().getX());
                        json.name("y").value(player.getPosition().getY());
                        json.name("z").value(player.getPosition().getZ());
                        json.endObject();
                        json.name("rotation").beginObject();
                        json.name("pitch").value(player.getRotation().getX());
                        json.name("yaw").value(player.getRotation().getY());
                        json.name("roll").value(player.getRotation().getZ());
                        json.endObject();
                        json.endObject();
                    }
                }
                json.endArray();
                json.endObject();
                json.flush();
                string = jsonString.toString();
            }
            return string;
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to write live/players json!", ex);
            return "BlueMap - Exception handling this request";
        }
    }
}

