/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin;

import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.common.BlueMapConfigProvider;
import de.bluecolored.bluemap.common.BlueMapService;
import de.bluecolored.bluemap.common.InterruptableReentrantLock;
import de.bluecolored.bluemap.common.api.BlueMapAPIImpl;
import de.bluecolored.bluemap.common.config.CoreConfig;
import de.bluecolored.bluemap.common.config.PluginConfig;
import de.bluecolored.bluemap.common.live.LivePlayersDataSupplier;
import de.bluecolored.bluemap.common.plugin.PluginState;
import de.bluecolored.bluemap.common.plugin.RegionFileWatchService;
import de.bluecolored.bluemap.common.plugin.skins.PlayerSkinUpdater;
import de.bluecolored.bluemap.common.rendermanager.MapUpdateTask;
import de.bluecolored.bluemap.common.rendermanager.RenderManager;
import de.bluecolored.bluemap.common.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.common.serverinterface.ServerInterface;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.common.web.http.HttpServer;
import de.bluecolored.bluemap.core.debug.StateDumper;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.resources.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.shadow.configurate.BasicConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

@DebugDump
public class Plugin
implements ServerEventListener {
    public static final String PLUGIN_ID = "bluemap";
    public static final String PLUGIN_NAME = "BlueMap";
    private static final String DEBUG_FILE_LOG_NAME = "file-debug-log";
    private final InterruptableReentrantLock loadingLock = new InterruptableReentrantLock();
    private final String implementationType;
    private final ServerInterface serverInterface;
    private BlueMapService blueMap;
    private PluginState pluginState;
    private Map<String, World> worlds;
    private Map<String, BmMap> maps;
    private RenderManager renderManager;
    private HttpServer webServer;
    private Logger webLogger;
    private BlueMapAPIImpl api;
    private Timer daemonTimer;
    private Map<String, RegionFileWatchService> regionFileWatchServices;
    private PlayerSkinUpdater skinUpdater;
    private boolean loaded = false;

    public Plugin(String implementationType, ServerInterface serverInterface) {
        this.implementationType = implementationType.toLowerCase();
        this.serverInterface = serverInterface;
        StateDumper.global().register(this);
    }

    public void load() throws IOException {
        this.load(null);
    }

    /*
     * Exception decompiling
     */
    private void load(@Nullable ResourcePack preloadedResourcePack) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void unload() {
        this.unload(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(boolean keepWebserver) {
        this.loadingLock.interruptAndLock();
        try {
            Plugin plugin = this;
            synchronized (plugin) {
                this.save();
                if (this.api != null) {
                    this.api.unregister();
                }
                this.api = null;
                this.serverInterface.unregisterAllListeners();
                this.skinUpdater = null;
                if (this.daemonTimer != null) {
                    this.daemonTimer.cancel();
                }
                this.daemonTimer = null;
                if (this.regionFileWatchServices != null) {
                    this.regionFileWatchServices.values().forEach(RegionFileWatchService::close);
                    this.regionFileWatchServices.clear();
                }
                this.regionFileWatchServices = null;
                if (this.renderManager != null) {
                    this.renderManager.stop();
                    try {
                        this.renderManager.awaitShutdown();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.renderManager = null;
                if (this.webServer != null && !keepWebserver) {
                    try {
                        this.webServer.close();
                    }
                    catch (IOException ex) {
                        Logger.global.logError("Failed to close the webserver!", ex);
                    }
                    this.webServer = null;
                }
                if (this.webLogger != null) {
                    try {
                        this.webLogger.close();
                    }
                    catch (Exception ex) {
                        Logger.global.logError("Failed to close the webserver-logger!", ex);
                    }
                    this.webLogger = null;
                }
                if (this.blueMap != null) {
                    try {
                        this.blueMap.close();
                    }
                    catch (IOException ex) {
                        Logger.global.logError("Failed to close a bluemap-service!", ex);
                    }
                }
                this.blueMap = null;
                Logger.global.remove(DEBUG_FILE_LOG_NAME);
                this.worlds = null;
                this.maps = null;
                this.pluginState = null;
                this.loaded = false;
            }
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    public void reload() throws IOException {
        this.unload();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lightReload() throws IOException {
        this.loadingLock.lock();
        try {
            Plugin plugin = this;
            synchronized (plugin) {
                block8: {
                    if (this.loaded) break block8;
                    this.reload();
                    return;
                }
                ResourcePack preloadedResourcePack = this.blueMap.getResourcePackIfLoaded().orElse(null);
                this.unload();
                this.load(preloadedResourcePack);
            }
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    public synchronized void save() {
        if (this.pluginState != null) {
            try {
                GsonConfigurationLoader loader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().path(this.blueMap.getConfigs().getCoreConfig().getData().resolve("pluginState.json"))).build();
                loader.save(((BasicConfigurationNode)loader.createNode()).set(PluginState.class, (Object)this.pluginState));
            }
            catch (IOException ex) {
                Logger.global.logError("Failed to save pluginState.json!", ex);
            }
        }
        if (this.maps != null) {
            for (BmMap map : this.maps.values()) {
                map.save();
            }
        }
    }

    public void saveMarkerStates() {
        if (this.maps != null) {
            for (BmMap map : this.maps.values()) {
                map.saveMarkerState();
            }
        }
    }

    public void savePlayerStates() {
        if (this.maps != null) {
            for (BmMap map : this.maps.values()) {
                LivePlayersDataSupplier dataSupplier = new LivePlayersDataSupplier(this.serverInterface, this.getConfigs().getPluginConfig(), map.getWorldId(), Predicate.not(this.pluginState::isPlayerHidden));
                try (OutputStream out = map.getStorage().writeMeta(map.getId(), "live/players.json");
                     OutputStreamWriter writer = new OutputStreamWriter(out);){
                    writer.write(dataSupplier.get());
                }
                catch (Exception ex) {
                    Logger.global.logError("Failed to save players for map '" + map.getId() + "'!", ex);
                }
            }
        }
    }

    public synchronized void startWatchingMap(BmMap map) {
        this.stopWatchingMap(map);
        try {
            RegionFileWatchService watcher = new RegionFileWatchService(this.renderManager, map, false);
            watcher.start();
            this.regionFileWatchServices.put(map.getId(), watcher);
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to create file-watcher for map: " + map.getId() + " (This means the map might not automatically update)", ex);
        }
    }

    public synchronized void stopWatchingMap(BmMap map) {
        RegionFileWatchService watcher = this.regionFileWatchServices.remove(map.getId());
        if (watcher != null) {
            watcher.close();
        }
    }

    public boolean flushWorldUpdates(World world) throws IOException {
        ServerWorld implWorld = this.serverInterface.getWorld(world.getSaveFolder()).orElse(null);
        if (implWorld != null) {
            return implWorld.persistWorldChanges();
        }
        return false;
    }

    @Override
    public void onPlayerJoin(UUID playerUuid) {
        this.checkPausedByPlayerCountSoon();
    }

    @Override
    public void onPlayerLeave(UUID playerUuid) {
        this.checkPausedByPlayerCountSoon();
    }

    private void checkPausedByPlayerCountSoon() {
        try {
            this.daemonTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Plugin.this.checkPausedByPlayerCount();
                }
            }, 1000L);
        }
        catch (IllegalStateException ex) {
            Logger.global.logWarning("Timer is already cancelled, skipping player-limit checks!");
        }
    }

    public boolean checkPausedByPlayerCount() {
        CoreConfig coreConfig = this.getConfigs().getCoreConfig();
        PluginConfig pluginConfig = this.getConfigs().getPluginConfig();
        if (pluginConfig.getPlayerRenderLimit() > 0 && this.getServerInterface().getOnlinePlayers().size() >= pluginConfig.getPlayerRenderLimit()) {
            if (this.renderManager.isRunning()) {
                this.renderManager.stop();
            }
            return true;
        }
        if (!this.renderManager.isRunning() && this.getPluginState().isRenderThreadsEnabled()) {
            this.renderManager.start(coreConfig.resolveRenderThreadCount());
        }
        return false;
    }

    public ServerInterface getServerInterface() {
        return this.serverInterface;
    }

    public BlueMapService getBlueMap() {
        return this.blueMap;
    }

    public BlueMapConfigProvider getConfigs() {
        return this.blueMap.getConfigs();
    }

    public PluginState getPluginState() {
        return this.pluginState;
    }

    public Map<String, World> getWorlds() {
        return this.worlds;
    }

    public Map<String, BmMap> getMaps() {
        return this.maps;
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    public HttpServer getWebServer() {
        return this.webServer;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String getImplementationType() {
        return this.implementationType;
    }

    public PlayerSkinUpdater getSkinUpdater() {
        return this.skinUpdater;
    }

    private void initFileWatcherTasks() {
        for (BmMap map : this.maps.values()) {
            if (!this.pluginState.getMapState(map).isUpdateEnabled()) continue;
            this.startWatchingMap(map);
        }
    }

    private /* synthetic */ void lambda$load$2(BmMap map) {
        if (this.pluginState.getMapState(map).isUpdateEnabled()) {
            this.renderManager.scheduleRenderTask(new MapUpdateTask(map));
        }
    }

    private static /* synthetic */ Integer lambda$load$1(BmMap bmMap) {
        return bmMap.getMapSettings().getSorting();
    }

    private static /* synthetic */ Logger lambda$load$0(CoreConfig coreConfig, ZonedDateTime zdt) throws Exception {
        return Logger.file(Path.of(String.format(coreConfig.getLog().getFile(), zdt), new String[0]), coreConfig.getLog().isAppend());
    }
}

