/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.common.rendermanager.RenderManager;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.util.FileHelper;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class RegionFileWatchService
extends Thread {
    private final BmMap map;
    private final RenderManager renderManager;
    private final WatchService watchService;
    private boolean verbose;
    private volatile boolean closed;
    private Timer delayTimer;
    @DebugDump
    private final Map<Vector2i, TimerTask> scheduledUpdates;

    public RegionFileWatchService(RenderManager renderManager, BmMap map, boolean verbose) throws IOException {
        this.renderManager = renderManager;
        this.map = map;
        this.verbose = verbose;
        this.closed = false;
        this.scheduledUpdates = new HashMap<Vector2i, TimerTask>();
        Path folder = map.getWorld().getSaveFolder().resolve("region");
        FileHelper.createDirectories(folder, new FileAttribute[0]);
        this.watchService = folder.getFileSystem().newWatchService();
        folder.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    @Override
    public void run() {
        if (this.delayTimer == null) {
            this.delayTimer = new Timer("BlueMap-RegionFileWatchService-DelayTimer", true);
        }
        try {
            while (!this.closed) {
                WatchKey key = this.watchService.take();
                for (WatchEvent<?> event : key.pollEvents()) {
                    Object fileObject;
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW || !((fileObject = event.context()) instanceof Path)) continue;
                    Path file = (Path)fileObject;
                    String regionFileName = file.toFile().getName();
                    this.updateRegion(regionFileName);
                }
                if (key.reset()) continue;
                return;
            }
        }
        catch (ClosedWatchServiceException key) {
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
        if (!this.closed) {
            Logger.global.logWarning("Region-file watch-service for map '" + this.map.getId() + "' stopped unexpectedly! (This map might not update automatically from now on)");
        }
    }

    private synchronized void updateRegion(String regionFileName) {
        if (!regionFileName.endsWith(".mca")) {
            return;
        }
        if (!regionFileName.startsWith("r.")) {
            return;
        }
        try {
            int rZ;
            String[] filenameParts = regionFileName.split("\\.");
            if (filenameParts.length < 3) {
                return;
            }
            int rX = Integer.parseInt(filenameParts[1]);
            final Vector2i regionPos = new Vector2i(rX, rZ = Integer.parseInt(filenameParts[2]));
            TimerTask task = this.scheduledUpdates.remove(regionPos);
            if (task != null) {
                task.cancel();
            }
            task = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    RegionFileWatchService regionFileWatchService = RegionFileWatchService.this;
                    synchronized (regionFileWatchService) {
                        WorldRegionRenderTask task = new WorldRegionRenderTask(RegionFileWatchService.this.map, regionPos);
                        RegionFileWatchService.this.scheduledUpdates.remove(regionPos);
                        RegionFileWatchService.this.renderManager.scheduleRenderTask(task);
                        if (RegionFileWatchService.this.verbose) {
                            Logger.global.logInfo("Scheduled update for region-file: " + regionPos + " (Map: " + RegionFileWatchService.this.map.getId() + ")");
                        }
                    }
                }
            };
            this.scheduledUpdates.put(regionPos, task);
            this.delayTimer.schedule(task, 10000L);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void close() {
        this.closed = true;
        this.interrupt();
        if (this.delayTimer != null) {
            this.delayTimer.cancel();
        }
        try {
            this.watchService.close();
        }
        catch (IOException ex) {
            Logger.global.logError("Exception while trying to close WatchService!", ex);
        }
    }
}

