/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractSuggestionProvider<S>
implements SuggestionProvider<S> {
    public CompletableFuture<Suggestions> getSuggestions(CommandContext<S> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        Collection<String> possibleValues = this.getPossibleValues();
        if (possibleValues.isEmpty()) {
            return Suggestions.empty();
        }
        String remaining = builder.getRemaining().toLowerCase();
        for (String str : possibleValues) {
            if (!str.toLowerCase().startsWith(remaining)) continue;
            str = StringArgumentType.escapeIfRequired((String)str);
            builder.suggest(str);
        }
        return builder.buildFuture();
    }

    public abstract Collection<String> getPossibleValues();
}

