/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.common.rendermanager.CombinedRenderTask;
import de.bluecolored.bluemap.common.rendermanager.MapSaveTask;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.world.Grid;
import de.bluecolored.bluemap.core.world.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@DebugDump
public class MapUpdateTask
extends CombinedRenderTask<RenderTask> {
    private final BmMap map;
    private final Collection<Vector2i> regions;

    public MapUpdateTask(BmMap map) {
        this(map, MapUpdateTask.getRegions(map));
    }

    public MapUpdateTask(BmMap map, boolean force) {
        this(map, MapUpdateTask.getRegions(map), force);
    }

    public MapUpdateTask(BmMap map, Vector2i center, int radius) {
        this(map, MapUpdateTask.getRegions(map, center, radius));
    }

    public MapUpdateTask(BmMap map, Vector2i center, int radius, boolean force) {
        this(map, MapUpdateTask.getRegions(map, center, radius), force);
    }

    public MapUpdateTask(BmMap map, Collection<Vector2i> regions) {
        this(map, regions, false);
    }

    public MapUpdateTask(BmMap map, Collection<Vector2i> regions, boolean force) {
        super("Update map '" + map.getId() + "'", MapUpdateTask.createTasks(map, regions, force));
        this.map = map;
        this.regions = Collections.unmodifiableCollection(new ArrayList<Vector2i>(regions));
    }

    public BmMap getMap() {
        return this.map;
    }

    public Collection<Vector2i> getRegions() {
        return this.regions;
    }

    private static Collection<RenderTask> createTasks(BmMap map, Collection<Vector2i> regions, boolean force) {
        ArrayList<WorldRegionRenderTask> regionTasks = new ArrayList<WorldRegionRenderTask>(regions.size());
        regions.forEach(region -> regionTasks.add(new WorldRegionRenderTask(map, (Vector2i)region, force)));
        World world = map.getWorld();
        Vector2i spawnPoint = world.getSpawnPoint().toVector2(true);
        Grid regionGrid = world.getRegionGrid();
        Vector2i spawnRegion = regionGrid.getCell(spawnPoint);
        regionTasks.sort(WorldRegionRenderTask.defaultComparator(spawnRegion));
        ArrayList<RenderTask> tasks = new ArrayList<RenderTask>(regionTasks.size() + 2);
        tasks.add(new MapSaveTask(map));
        tasks.addAll(regionTasks);
        tasks.add(new MapSaveTask(map));
        return tasks;
    }

    private static List<Vector2i> getRegions(BmMap map) {
        return MapUpdateTask.getRegions(map, null, -1);
    }

    private static List<Vector2i> getRegions(BmMap map, Vector2i center, int radius) {
        World world = map.getWorld();
        Grid regionGrid = world.getRegionGrid();
        Predicate<Vector2i> regionFilter = r -> {
            Vector2i cellMin = regionGrid.getCellMin((Vector2i)r);
            if (cellMin.getX() > map.getMapSettings().getMaxPos().getX()) {
                return false;
            }
            if (cellMin.getY() > map.getMapSettings().getMaxPos().getZ()) {
                return false;
            }
            Vector2i cellMax = regionGrid.getCellMax((Vector2i)r);
            if (cellMax.getX() < map.getMapSettings().getMinPos().getX()) {
                return false;
            }
            return cellMax.getY() >= map.getMapSettings().getMinPos().getZ();
        };
        if (center == null || radius < 0) {
            return world.listRegions().stream().filter(regionFilter).collect(Collectors.toList());
        }
        ArrayList<Vector2i> regions = new ArrayList<Vector2i>();
        Vector2i halfCell = regionGrid.getGridSize().div(2);
        long increasedRadiusSquared = (long)Math.pow((double)radius + Math.ceil(halfCell.length()), 2.0);
        for (Vector2i region : world.listRegions()) {
            Vector2i min2;
            Vector2i regionCenter;
            if (!regionFilter.test(region) || (regionCenter = (min2 = regionGrid.getCellMin(region)).add(halfCell)).toLong().distanceSquared(center.toLong()) > increasedRadiusSquared) continue;
            regions.add(region);
        }
        return regions;
    }
}

