/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import de.bluecolored.bluemap.core.BlueMap;

public class BlueMapResponseModifier
implements HttpRequestHandler {
    private final HttpRequestHandler delegate;
    private final String serverName;

    public BlueMapResponseModifier(HttpRequestHandler delegate) {
        this.delegate = delegate;
        this.serverName = "BlueMap/" + BlueMap.VERSION;
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        HttpResponse response = this.delegate.handle(request);
        HttpStatusCode status = response.getStatusCode();
        if (status.getCode() >= 400 && !response.hasData()) {
            response.setData(status.getCode() + " - " + status.getMessage() + "\n" + this.serverName);
        }
        response.addHeader("Server", this.serverName);
        return response;
    }
}

