/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.api.ContentTypeRegistry;
import de.bluecolored.bluemap.common.web.http.HttpHeader;
import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.storage.CompressedInputStream;
import de.bluecolored.bluemap.core.storage.Compression;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.storage.TileInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class MapStorageRequestHandler
implements HttpRequestHandler {
    private static final Pattern TILE_PATTERN = Pattern.compile("tiles/([\\d/]+)/x(-?[\\d/]+)z(-?[\\d/]+).*");
    private final String mapId;
    private final Storage mapStorage;

    public MapStorageRequestHandler(BmMap map) {
        this.mapId = map.getId();
        this.mapStorage = map.getStorage();
    }

    public MapStorageRequestHandler(String mapId, Storage mapStorage) {
        this.mapId = mapId;
        this.mapStorage = mapStorage;
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        String path = request.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            int z;
            int x;
            int lod;
            Optional<TileInfo> optTileInfo;
            Matcher tileMatcher = TILE_PATTERN.matcher(path);
            if (tileMatcher.matches() && (optTileInfo = this.mapStorage.readMapTileInfo(this.mapId, lod = Integer.parseInt(tileMatcher.group(1)), new Vector2i(x = Integer.parseInt(tileMatcher.group(2).replace("/", "")), z = Integer.parseInt(tileMatcher.group(3).replace("/", ""))))).isPresent()) {
                TileInfo tileInfo = optTileInfo.get();
                String eTag = this.calculateETag(path, tileInfo);
                HttpHeader etagHeader = request.getHeader("If-None-Match");
                if (etagHeader != null && etagHeader.getValue().equals(eTag)) {
                    return new HttpResponse(HttpStatusCode.NOT_MODIFIED);
                }
                long lastModified = tileInfo.getLastModified();
                HttpHeader modHeader = request.getHeader("If-Modified-Since");
                if (modHeader != null) {
                    try {
                        long since = MapStorageRequestHandler.stringToTimestamp(modHeader.getValue());
                        if (since + 1000L >= lastModified) {
                            return new HttpResponse(HttpStatusCode.NOT_MODIFIED);
                        }
                    }
                    catch (IllegalArgumentException since) {
                        // empty catch block
                    }
                }
                CompressedInputStream compressedIn = tileInfo.readMapTile();
                HttpResponse response = new HttpResponse(HttpStatusCode.OK);
                response.addHeader("ETag", eTag);
                if (lastModified > 0L) {
                    response.addHeader("Last-Modified", MapStorageRequestHandler.timestampToString(lastModified));
                }
                if (lod == 0) {
                    response.addHeader("Content-Type", "application/json");
                } else {
                    response.addHeader("Content-Type", "image/png");
                }
                this.writeToResponse(compressedIn, response, request);
                return response;
            }
            Optional<InputStream> optIn = this.mapStorage.readMeta(this.mapId, path);
            if (optIn.isPresent()) {
                CompressedInputStream compressedIn = new CompressedInputStream(optIn.get(), Compression.NONE);
                HttpResponse response = new HttpResponse(HttpStatusCode.OK);
                response.addHeader("Content-Type", ContentTypeRegistry.fromFileName(path));
                this.writeToResponse(compressedIn, response, request);
                return response;
            }
        }
        catch (NumberFormatException | NoSuchElementException tileMatcher) {
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to read map-tile for web-request.", ex);
            return new HttpResponse(HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        if (path.endsWith(".png")) {
            return new HttpResponse(HttpStatusCode.NO_CONTENT);
        }
        if (path.endsWith(".json")) {
            HttpResponse response = new HttpResponse(HttpStatusCode.OK);
            response.addHeader("Content-Type", "application/json");
            response.setData("{}");
            return response;
        }
        return new HttpResponse(HttpStatusCode.NOT_FOUND);
    }

    private String calculateETag(String path, TileInfo tileInfo) {
        return Long.toHexString(tileInfo.getSize()) + Integer.toHexString(path.hashCode()) + Long.toHexString(tileInfo.getLastModified());
    }

    private void writeToResponse(CompressedInputStream data, HttpResponse response, HttpRequest request) throws IOException {
        Compression compression = data.getCompression();
        if (compression != Compression.NONE && request.hasHeaderValue("Accept-Encoding", compression.getTypeId())) {
            response.addHeader("Content-Encoding", compression.getTypeId());
            response.setData(data);
        } else if (compression != Compression.GZIP && !response.hasHeaderValue("Content-Type", "image/png") && request.hasHeaderValue("Accept-Encoding", Compression.GZIP.getTypeId())) {
            response.addHeader("Content-Encoding", Compression.GZIP.getTypeId());
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try (OutputStream os = Compression.GZIP.compress(byteOut);){
                IOUtils.copyLarge((InputStream)data.decompress(), (OutputStream)os);
            }
            byte[] compressedData = byteOut.toByteArray();
            response.setData(new ByteArrayInputStream(compressedData));
        } else {
            response.setData(data.decompress());
        }
    }

    private static String timestampToString(long time) {
        return DateFormatUtils.format((long)time, (String)"EEE, dd MMM yyy HH:mm:ss 'GMT'", (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.ENGLISH);
    }

    private static long stringToTimestamp(String timeString) throws IllegalArgumentException {
        try {
            int day = Integer.parseInt(timeString.substring(5, 7));
            int month = 0;
            switch (timeString.substring(8, 11)) {
                case "Feb": {
                    month = 1;
                    break;
                }
                case "Mar": {
                    month = 2;
                    break;
                }
                case "Apr": {
                    month = 3;
                    break;
                }
                case "May": {
                    month = 4;
                    break;
                }
                case "Jun": {
                    month = 5;
                    break;
                }
                case "Jul": {
                    month = 6;
                    break;
                }
                case "Aug": {
                    month = 7;
                    break;
                }
                case "Sep": {
                    month = 8;
                    break;
                }
                case "Oct": {
                    month = 9;
                    break;
                }
                case "Nov": {
                    month = 10;
                    break;
                }
                case "Dec": {
                    month = 11;
                }
            }
            int year = Integer.parseInt(timeString.substring(12, 16));
            int hour = Integer.parseInt(timeString.substring(17, 19));
            int min2 = Integer.parseInt(timeString.substring(20, 22));
            int sec = Integer.parseInt(timeString.substring(23, 25));
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            cal.set(year, month, day, hour, min2, sec);
            return cal.getTimeInMillis();
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

