/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.debug;

import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.ConfigurationOptions;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class StateDumper {
    private static final StateDumper GLOBAL = new StateDumper();
    private final Set<Object> instances = Collections.newSetFromMap(new WeakHashMap());

    public void dump(Path file) throws IOException {
        GsonConfigurationLoader loader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().path(file)).build();
        Object node = loader.createNode();
        this.collectSystemInfo(node.node("system-info"));
        Set<Object> alreadyDumped = Collections.newSetFromMap(new WeakHashMap());
        try {
            ConfigurationNode threadDump = node.node("threads");
            for (Thread thread : Thread.getAllStackTraces().keySet()) {
                this.dumpInstance(thread, loader.defaultOptions(), threadDump.appendListNode(), alreadyDumped);
            }
        }
        catch (SecurityException ex) {
            node.node("threads").set(ex.toString());
        }
        ConfigurationNode dump = node.node("dump");
        for (Object instance : this.instances) {
            Class<?> type = instance.getClass();
            ConfigurationNode instanceDump = dump.node(type.getName()).appendListNode();
            this.dumpInstance(instance, loader.defaultOptions(), instanceDump, alreadyDumped);
        }
        loader.save((ConfigurationNode)node);
    }

    private void dumpInstance(Object instance, ConfigurationOptions options, ConfigurationNode node, Set<Object> alreadyDumped) throws SerializationException {
        try {
            if (instance == null) {
                node.raw(null);
                return;
            }
            Class<?> type = instance.getClass();
            if (!alreadyDumped.add(instance)) {
                node.set("<<" + instance + ">>");
                return;
            }
            if (instance instanceof Map) {
                int count = 0;
                Map map = (Map)instance;
                if (map.isEmpty()) {
                    node.set(map.toString());
                    return;
                }
                for (Map.Entry entry : map.entrySet()) {
                    if (++count > 100) {
                        node.appendListNode().set("<<" + (map.size() - 100) + " more elements>>");
                        break;
                    }
                    ConfigurationNode entryNode = node.appendListNode();
                    this.dumpInstance(entry.getKey(), options, entryNode.node("key"), alreadyDumped);
                    this.dumpInstance(entry.getValue(), options, entryNode.node("value"), alreadyDumped);
                }
                return;
            }
            if (instance instanceof Collection) {
                if (((Collection)instance).isEmpty()) {
                    node.set(instance.toString());
                    return;
                }
                int count = 0;
                for (Object entry : (Collection)instance) {
                    if (++count > 100) {
                        node.appendListNode().set("<<" + (((Collection)instance).size() - 100) + " more elements>>");
                        break;
                    }
                    this.dumpInstance(entry, options, node.appendListNode(), alreadyDumped);
                }
                return;
            }
            if (instance instanceof Object[]) {
                if (((Object[])instance).length == 0) {
                    node.set(instance.toString());
                    return;
                }
                int count = 0;
                for (Object entry : (Object[])instance) {
                    if (++count > 100) {
                        node.appendListNode().set("<<" + (((Object[])instance).length - 100) + " more elements>>");
                        break;
                    }
                    this.dumpInstance(entry, options, node.appendListNode(), alreadyDumped);
                }
                return;
            }
            if (instance instanceof Thread) {
                Thread t = (Thread)instance;
                node.node("name").set(t.getName());
                node.node("state").set(t.getState().toString());
                node.node("priority").set(t.getPriority());
                node.node("alive").set(t.isAlive());
                node.node("id").set(t.getId());
                node.node("deamon").set(t.isDaemon());
                node.node("interrupted").set(t.isInterrupted());
                this.dumpInstance(t.getStackTrace(), options, node.node("stackTrace"), alreadyDumped);
                return;
            }
            boolean foundSomething = this.dumpAnnotatedInstance(type, instance, options, node, alreadyDumped);
            if (!foundSomething) {
                node.set(instance.toString());
            }
        }
        catch (Exception ex) {
            StringWriter stringWriter = new StringWriter();
            ex.printStackTrace(new PrintWriter(stringWriter));
            node.set("Error: " + ex + " >> " + stringWriter);
        }
    }

    private boolean dumpAnnotatedInstance(Class<?> type, Object instance, ConfigurationOptions options, ConfigurationNode node, Set<Object> alreadyDumped) throws Exception {
        String key;
        DebugDump dd;
        boolean foundSomething = false;
        boolean allFields = type.isAnnotationPresent(DebugDump.class);
        for (Field field : type.getDeclaredFields()) {
            dd = field.getAnnotation(DebugDump.class);
            if (dd == null && (!allFields || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()))) continue;
            foundSomething = true;
            key = "";
            if (dd != null) {
                key = dd.value();
            }
            if (key.isEmpty()) {
                key = field.getName();
            }
            field.setAccessible(true);
            if (options.acceptsType(field.getType())) {
                node.node(key).set(field.get(instance));
                continue;
            }
            this.dumpInstance(field.get(instance), options, node.node(key), alreadyDumped);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            dd = ((Method)accessibleObject).getAnnotation(DebugDump.class);
            if (dd == null) continue;
            foundSomething = true;
            key = dd.value();
            if (key.isEmpty()) {
                key = ((Method)accessibleObject).toGenericString().replace(' ', '_');
            }
            if (options.acceptsType(((Method)accessibleObject).getReturnType())) {
                ((Method)accessibleObject).setAccessible(true);
                node.node(key).set(((Method)accessibleObject).invoke(instance, new Object[0]));
                continue;
            }
            ((Method)accessibleObject).setAccessible(true);
            this.dumpInstance(((Method)accessibleObject).invoke(instance, new Object[0]), options, node.node(key), alreadyDumped);
        }
        for (AnnotatedElement annotatedElement : type.getInterfaces()) {
            foundSomething |= this.dumpAnnotatedInstance((Class<?>)annotatedElement, instance, options, node, alreadyDumped);
        }
        Class<?> typeSuperclass = type.getSuperclass();
        if (typeSuperclass != null) {
            foundSomething |= this.dumpAnnotatedInstance(typeSuperclass, instance, options, node, alreadyDumped);
        }
        return foundSomething;
    }

    private void collectSystemInfo(ConfigurationNode node) throws SerializationException {
        node.node("bluemap-version").set(BlueMap.VERSION);
        node.node("git-hash").set(BlueMap.GIT_HASH);
        String[] properties = new String[]{"java.runtime.name", "java.runtime.version", "java.vm.vendor", "java.vm.name", "os.name", "os.version", "user.dir", "java.home", "file.separator", "sun.io.unicode.encoding", "java.class.version"};
        HashMap<String, String> propMap = new HashMap<String, String>();
        for (String key : properties) {
            propMap.put(key, System.getProperty(key));
        }
        node.node("system-properties").set(propMap);
        node.node("cores").set(Runtime.getRuntime().availableProcessors());
        node.node("max-memory").set(Runtime.getRuntime().maxMemory());
        node.node("total-memory").set(Runtime.getRuntime().totalMemory());
        node.node("free-memory").set(Runtime.getRuntime().freeMemory());
        node.node("timestamp").set(System.currentTimeMillis());
        node.node("time").set(LocalDateTime.now().toString());
    }

    public static StateDumper global() {
        return GLOBAL;
    }

    public synchronized void register(Object instance) {
        StateDumper.GLOBAL.instances.add(instance);
    }

    public synchronized void unregister(Object instance) {
        StateDumper.GLOBAL.instances.remove(instance);
    }
}

