/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.TileMetaConsumer;
import de.bluecolored.bluemap.core.map.hires.BlockModelView;
import de.bluecolored.bluemap.core.map.hires.HiresTileModel;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.blockmodel.BlockStateModelFactory;
import de.bluecolored.bluemap.core.resources.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.BlockNeighborhood;
import de.bluecolored.bluemap.core.world.World;

public class HiresModelRenderer {
    private final ResourcePack resourcePack;
    private final TextureGallery textureGallery;
    private final RenderSettings renderSettings;

    public HiresModelRenderer(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
        this.resourcePack = resourcePack;
        this.textureGallery = textureGallery;
        this.renderSettings = renderSettings;
    }

    public void render(World world, Vector3i modelMin, Vector3i modelMax, HiresTileModel model) {
        this.render(world, modelMin, modelMax, model, (x, z, c, h2, l) -> {});
    }

    public void render(World world, Vector3i modelMin, Vector3i modelMax, HiresTileModel model, TileMetaConsumer tileMetaConsumer) {
        Vector3i min2 = modelMin.max(this.renderSettings.getMinPos());
        Vector3i max = modelMax.min(this.renderSettings.getMaxPos());
        Vector3i modelAnchor = new Vector3i(modelMin.getX(), 0, modelMin.getZ());
        BlockStateModelFactory modelFactory = new BlockStateModelFactory(this.resourcePack, this.textureGallery, this.renderSettings);
        Color columnColor = new Color();
        Color blockColor = new Color();
        BlockNeighborhood block = new BlockNeighborhood(this.resourcePack, this.renderSettings, world, 0, 0, 0);
        BlockModelView blockModel = new BlockModelView(model);
        for (int x = min2.getX(); x <= max.getX(); ++x) {
            for (int z = min2.getZ(); z <= max.getZ(); ++z) {
                int maxHeight = 0;
                double topBlockLight = 0.0;
                columnColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
                if (this.renderSettings.isInsideRenderBoundaries(x, z)) {
                    int minY = Math.max(min2.getY(), world.getMinY(x, z));
                    int maxY = Math.min(max.getY(), world.getMaxY(x, z));
                    for (int y = minY; y <= maxY; ++y) {
                        block.set(x, y, z);
                        if (!block.isInsideRenderBounds()) continue;
                        blockModel.initialize();
                        modelFactory.render(block, blockModel, blockColor);
                        if (y >= this.renderSettings.getRemoveCavesBelowY() || (this.renderSettings.isCaveDetectionUsesBlockLight() ? block.getBlockLightLevel() : block.getSunLightLevel()) > 0) {
                            if (blockColor.a > 0.0f) {
                                topBlockLight = Math.floor(topBlockLight * (double)(1.0f - blockColor.a));
                            }
                            topBlockLight = Math.max(topBlockLight, (double)block.getBlockLightLevel());
                        } else {
                            topBlockLight = 0.0;
                        }
                        if (blockModel.getSize() <= 0) continue;
                        blockModel.translate(x - modelAnchor.getX(), y - modelAnchor.getY(), z - modelAnchor.getZ());
                        if (!(blockColor.a > 0.0f)) continue;
                        maxHeight = y;
                        columnColor.overlay(blockColor.premultiplied());
                    }
                }
                tileMetaConsumer.set(x, z, columnColor, maxHeight, (int)topBlockLight);
            }
        }
    }
}

