/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.mca;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.mca.LegacyBiomes;
import de.bluecolored.bluemap.core.mca.MCAChunk;
import de.bluecolored.bluemap.core.mca.MCAMath;
import de.bluecolored.bluemap.core.mca.MCAWorld;
import de.bluecolored.bluemap.core.world.Biome;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.shadow.querz.nbt.ByteArrayTag;
import de.bluecolored.shadow.querz.nbt.CompoundTag;
import de.bluecolored.shadow.querz.nbt.IntArrayTag;
import de.bluecolored.shadow.querz.nbt.ListTag;
import de.bluecolored.shadow.querz.nbt.NumberTag;
import de.bluecolored.shadow.querz.nbt.StringTag;
import de.bluecolored.shadow.querz.nbt.Tag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ChunkAnvil115
extends MCAChunk {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private boolean isGenerated;
    private boolean hasLight;
    private long inhabitedTime;
    private Section[] sections;
    private int[] biomes;
    private long[] oceanFloorHeights = EMPTY_LONG_ARRAY;
    private long[] worldSurfaceHeights = EMPTY_LONG_ARRAY;

    public ChunkAnvil115(MCAWorld world, CompoundTag chunkTag) {
        super(world, chunkTag);
        Tag<?> tag;
        CompoundTag levelData = chunkTag.getCompoundTag("Level");
        String status = levelData.getString("Status");
        this.hasLight = this.isGenerated = status.equals("full");
        this.inhabitedTime = levelData.getLong("InhabitedTime");
        if (!this.isGenerated && this.getWorld().isIgnoreMissingLightData()) {
            boolean bl = this.isGenerated = !status.equals("empty");
        }
        if (levelData.containsKey("Heightmaps")) {
            CompoundTag heightmapsTag = levelData.getCompoundTag("Heightmaps");
            this.worldSurfaceHeights = heightmapsTag.getLongArray("WORLD_SURFACE");
            this.oceanFloorHeights = heightmapsTag.getLongArray("OCEAN_FLOOR");
        }
        this.sections = new Section[32];
        if (levelData.containsKey("Sections")) {
            for (CompoundTag sectionTag : levelData.getListTag("Sections")) {
                Section section = new Section(sectionTag);
                if (section.getSectionY() < 0 || section.getSectionY() >= this.sections.length) continue;
                this.sections[section.getSectionY()] = section;
            }
        } else {
            this.sections = new Section[0];
        }
        if ((tag = levelData.get("Biomes")) instanceof ByteArrayTag) {
            byte[] bs = (byte[])((ByteArrayTag)tag).getValue();
            this.biomes = new int[bs.length];
            for (int i = 0; i < bs.length; ++i) {
                this.biomes[i] = bs[i] & 0xFF;
            }
        } else if (tag instanceof IntArrayTag) {
            this.biomes = (int[])((IntArrayTag)tag).getValue();
        }
        if (this.biomes == null || this.biomes.length == 0) {
            this.biomes = new int[1024];
        }
        if (this.biomes.length < 1024) {
            this.biomes = Arrays.copyOf(this.biomes, 1024);
        }
    }

    @Override
    public boolean isGenerated() {
        return this.isGenerated;
    }

    @Override
    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        int sectionY = y >> 4;
        if (sectionY < 0 || sectionY >= this.sections.length) {
            return BlockState.AIR;
        }
        Section section = this.sections[sectionY];
        if (section == null) {
            return BlockState.AIR;
        }
        return section.getBlockState(x, y, z);
    }

    @Override
    public LightData getLightData(int x, int y, int z, LightData target) {
        if (!this.hasLight) {
            return target.set(this.getWorld().getSkyLight(), 0);
        }
        int sectionY = y >> 4;
        if (sectionY < 0 || sectionY >= this.sections.length) {
            return y < 0 ? target.set(0, 0) : target.set(this.getWorld().getSkyLight(), 0);
        }
        Section section = this.sections[sectionY];
        if (section == null) {
            return target.set(this.getWorld().getSkyLight(), 0);
        }
        return section.getLightData(x, y, z, target);
    }

    @Override
    public String getBiome(int x, int y, int z) {
        int biomeIntIndex = (y /= 4) * 16 + (z = (z & 0xF) / 4) * 4 + (x = (x & 0xF) / 4);
        if (biomeIntIndex < 0) {
            return Biome.DEFAULT.getFormatted();
        }
        if (biomeIntIndex >= this.biomes.length) {
            return Biome.DEFAULT.getFormatted();
        }
        return LegacyBiomes.idFor(this.biomes[biomeIntIndex]);
    }

    @Override
    public int getMaxY(int x, int z) {
        return this.sections.length * 16 + 15;
    }

    @Override
    public int getWorldSurfaceY(int x, int z) {
        if (this.worldSurfaceHeights.length < 36) {
            return 0;
        }
        return (int)MCAMath.getValueFromLongStream(this.worldSurfaceHeights, (z &= 0xF) * 16 + (x &= 0xF), 9);
    }

    @Override
    public int getOceanFloorY(int x, int z) {
        if (this.oceanFloorHeights.length < 36) {
            return 0;
        }
        return (int)MCAMath.getValueFromLongStream(this.oceanFloorHeights, (z &= 0xF) * 16 + (x &= 0xF), 9);
    }

    private static class Section {
        private static final String AIR_ID = "minecraft:air";
        private int sectionY;
        private byte[] blockLight;
        private byte[] skyLight;
        private long[] blocks;
        private BlockState[] palette;
        private int bitsPerBlock;

        public Section(CompoundTag sectionData) {
            ListTag<?> paletteTag;
            this.sectionY = sectionData.get("Y", NumberTag.class).asInt();
            this.blockLight = sectionData.getByteArray("BlockLight");
            this.skyLight = sectionData.getByteArray("SkyLight");
            this.blocks = sectionData.getLongArray("BlockStates");
            if (this.blocks.length < 256 && this.blocks.length > 0) {
                this.blocks = Arrays.copyOf(this.blocks, 256);
            }
            if (this.blockLight.length < 2048 && this.blockLight.length > 0) {
                this.blockLight = Arrays.copyOf(this.blockLight, 2048);
            }
            if (this.skyLight.length < 2048 && this.skyLight.length > 0) {
                this.skyLight = Arrays.copyOf(this.skyLight, 2048);
            }
            if ((paletteTag = sectionData.getListTag("Palette")) != null) {
                this.palette = new BlockState[paletteTag.size()];
                for (int i = 0; i < this.palette.length; ++i) {
                    CompoundTag stateTag = (CompoundTag)paletteTag.get(i);
                    String id = stateTag.getString("Name");
                    if (id.equals(AIR_ID)) {
                        this.palette[i] = BlockState.AIR;
                        continue;
                    }
                    HashMap<String, String> properties = new HashMap<String, String>();
                    if (stateTag.containsKey("Properties")) {
                        CompoundTag propertiesTag = stateTag.getCompoundTag("Properties");
                        for (Map.Entry<String, Tag<?>> property : propertiesTag) {
                            properties.put(property.getKey().toLowerCase(), ((StringTag)property.getValue()).getValue().toLowerCase());
                        }
                    }
                    this.palette[i] = new BlockState(id, properties);
                }
            } else {
                this.palette = new BlockState[0];
            }
            this.bitsPerBlock = this.blocks.length >> 6;
        }

        public int getSectionY() {
            return this.sectionY;
        }

        public BlockState getBlockState(int x, int y, int z) {
            if (this.palette.length == 1) {
                return this.palette[0];
            }
            if (this.blocks.length == 0) {
                return BlockState.AIR;
            }
            int blockIndex = (y &= 0xF) * 256 + (z &= 0xF) * 16 + (x &= 0xF);
            long value = MCAMath.getValueFromLongStream(this.blocks, blockIndex, this.bitsPerBlock);
            if (value >= (long)this.palette.length) {
                Logger.global.noFloodWarning("palettewarning", "Got palette value " + value + " but palette has size of " + this.palette.length + " (Future occasions of this error will not be logged)");
                return BlockState.MISSING;
            }
            return this.palette[(int)value];
        }

        public LightData getLightData(int x, int y, int z, LightData target) {
            if (this.blockLight.length == 0 && this.skyLight.length == 0) {
                return target.set(0, 0);
            }
            int blockByteIndex = (y &= 0xF) * 256 + (z &= 0xF) * 16 + (x &= 0xF);
            int blockHalfByteIndex = blockByteIndex >> 1;
            boolean largeHalf = (blockByteIndex & 1) != 0;
            return target.set(this.skyLight.length > 0 ? MCAMath.getByteHalf(this.skyLight[blockHalfByteIndex], largeHalf) : 0, this.blockLight.length > 0 ? MCAMath.getByteHalf(this.blockLight[blockHalfByteIndex], largeHalf) : 0);
        }
    }
}

