/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.mca;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.mca.MCAChunk;
import de.bluecolored.bluemap.core.mca.MCAMath;
import de.bluecolored.bluemap.core.mca.MCAWorld;
import de.bluecolored.bluemap.core.world.Biome;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.shadow.querz.nbt.CompoundTag;
import de.bluecolored.shadow.querz.nbt.ListTag;
import de.bluecolored.shadow.querz.nbt.NumberTag;
import de.bluecolored.shadow.querz.nbt.StringTag;
import de.bluecolored.shadow.querz.nbt.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ChunkAnvil118
extends MCAChunk {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final BlockState[] EMPTY_BLOCK_STATE_ARRAY = new BlockState[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private boolean isGenerated;
    private boolean hasLight;
    private long inhabitedTime;
    private int sectionMin;
    private int sectionMax;
    private Section[] sections;
    private long[] oceanFloorHeights = EMPTY_LONG_ARRAY;
    private long[] worldSurfaceHeights = EMPTY_LONG_ARRAY;

    public ChunkAnvil118(MCAWorld world, CompoundTag chunkTag) {
        super(world, chunkTag);
        String status = chunkTag.getString("Status");
        this.hasLight = this.isGenerated = status.equals("full") || status.equals("minecraft:full");
        this.inhabitedTime = chunkTag.getLong("InhabitedTime");
        if (!this.isGenerated && this.getWorld().isIgnoreMissingLightData()) {
            boolean bl = this.isGenerated = !status.equals("empty") && !status.equals("minecraft:empty");
        }
        if (chunkTag.containsKey("Heightmaps")) {
            CompoundTag heightmapsTag = chunkTag.getCompoundTag("Heightmaps");
            this.worldSurfaceHeights = heightmapsTag.getLongArray("WORLD_SURFACE");
            this.oceanFloorHeights = heightmapsTag.getLongArray("OCEAN_FLOOR");
        }
        if (chunkTag.containsKey("sections")) {
            this.sectionMin = Integer.MAX_VALUE;
            this.sectionMax = Integer.MIN_VALUE;
            ListTag<?> sectionsTag = chunkTag.getListTag("sections");
            ArrayList<Section> sectionList = new ArrayList<Section>(sectionsTag.size());
            for (CompoundTag sectionTag : sectionsTag) {
                Section section = new Section(sectionTag);
                int y = section.getSectionY();
                if (this.sectionMin > y) {
                    this.sectionMin = y;
                }
                if (this.sectionMax < y) {
                    this.sectionMax = y;
                }
                sectionList.add(section);
            }
            this.sections = new Section[1 + this.sectionMax - this.sectionMin];
            Iterator<Object> iterator = sectionList.iterator();
            while (iterator.hasNext()) {
                Section section;
                this.sections[section.sectionY - this.sectionMin] = section = (Section)iterator.next();
            }
        } else {
            this.sections = new Section[0];
        }
    }

    @Override
    public boolean isGenerated() {
        return this.isGenerated;
    }

    @Override
    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        int sectionY = y >> 4;
        Section section = this.getSection(sectionY);
        if (section == null) {
            return BlockState.AIR;
        }
        return section.getBlockState(x, y, z);
    }

    @Override
    public LightData getLightData(int x, int y, int z, LightData target) {
        if (!this.hasLight) {
            return target.set(this.getWorld().getSkyLight(), 0);
        }
        int sectionY = y >> 4;
        Section section = this.getSection(sectionY);
        if (section == null) {
            return sectionY < this.sectionMin ? target.set(0, 0) : target.set(this.getWorld().getSkyLight(), 0);
        }
        return section.getLightData(x, y, z, target);
    }

    @Override
    public String getBiome(int x, int y, int z) {
        int sectionY = y >> 4;
        Section section = this.getSection(sectionY);
        if (section == null) {
            return Biome.DEFAULT.getFormatted();
        }
        return section.getBiome(x, y, z);
    }

    @Override
    public int getMinY(int x, int z) {
        return this.sectionMin * 16;
    }

    @Override
    public int getMaxY(int x, int z) {
        return this.sectionMax * 16 + 15;
    }

    @Override
    public int getWorldSurfaceY(int x, int z) {
        if (this.worldSurfaceHeights.length < 37) {
            return 0;
        }
        return (int)MCAMath.getValueFromLongArray(this.worldSurfaceHeights, (z &= 0xF) * 16 + (x &= 0xF), 9) - 64;
    }

    @Override
    public int getOceanFloorY(int x, int z) {
        if (this.oceanFloorHeights.length < 37) {
            return 0;
        }
        return (int)MCAMath.getValueFromLongArray(this.oceanFloorHeights, (z &= 0xF) * 16 + (x &= 0xF), 9) - 64;
    }

    private Section getSection(int y) {
        if ((y -= this.sectionMin) < 0 || y >= this.sections.length) {
            return null;
        }
        return this.sections[y];
    }

    private static class Section {
        private int sectionY;
        private byte[] blockLight;
        private byte[] skyLight;
        private long[] blocks = EMPTY_LONG_ARRAY;
        private long[] biomes = EMPTY_LONG_ARRAY;
        private BlockState[] blockPalette = EMPTY_BLOCK_STATE_ARRAY;
        private String[] biomePalette = EMPTY_STRING_ARRAY;
        private int bitsPerBlock;
        private int bitsPerBiome;

        public Section(CompoundTag sectionData) {
            CompoundTag biomesTag;
            this.sectionY = sectionData.get("Y", NumberTag.class).asInt();
            this.blockLight = sectionData.getByteArray("BlockLight");
            this.skyLight = sectionData.getByteArray("SkyLight");
            CompoundTag blockStatesTag = sectionData.getCompoundTag("block_states");
            if (blockStatesTag != null) {
                this.blocks = blockStatesTag.getLongArray("data");
                ListTag<?> paletteTag = blockStatesTag.getListTag("palette");
                if (paletteTag != null) {
                    this.blockPalette = new BlockState[paletteTag.size()];
                    for (int i = 0; i < this.blockPalette.length; ++i) {
                        this.blockPalette[i] = this.readBlockStatePaletteEntry((CompoundTag)paletteTag.get(i));
                    }
                }
            }
            if ((biomesTag = sectionData.getCompoundTag("biomes")) != null) {
                this.biomes = biomesTag.getLongArray("data");
                ListTag<?> paletteTag = biomesTag.getListTag("palette");
                if (paletteTag != null) {
                    this.biomePalette = new String[paletteTag.size()];
                    for (int i = 0; i < this.biomePalette.length; ++i) {
                        this.biomePalette[i] = ((StringTag)paletteTag.get(i)).getValue();
                    }
                }
            }
            if (this.blocks.length < 256 && this.blocks.length > 0) {
                this.blocks = Arrays.copyOf(this.blocks, 256);
            }
            if (this.blockLight.length < 2048 && this.blockLight.length > 0) {
                this.blockLight = Arrays.copyOf(this.blockLight, 2048);
            }
            if (this.skyLight.length < 2048 && this.skyLight.length > 0) {
                this.skyLight = Arrays.copyOf(this.skyLight, 2048);
            }
            this.bitsPerBlock = this.blocks.length >> 6;
            this.bitsPerBiome = 32 - Integer.numberOfLeadingZeros(this.biomePalette.length - 1);
        }

        private BlockState readBlockStatePaletteEntry(CompoundTag paletteEntry) {
            String id = paletteEntry.getString("Name");
            if (BlockState.AIR.getFormatted().equals(id)) {
                return BlockState.AIR;
            }
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            if (paletteEntry.containsKey("Properties")) {
                CompoundTag propertiesTag = paletteEntry.getCompoundTag("Properties");
                for (Map.Entry<String, Tag<?>> property : propertiesTag) {
                    properties.put(property.getKey().toLowerCase(), ((StringTag)property.getValue()).getValue().toLowerCase());
                }
            }
            return new BlockState(id, properties);
        }

        public int getSectionY() {
            return this.sectionY;
        }

        public BlockState getBlockState(int x, int y, int z) {
            if (this.blockPalette.length == 1) {
                return this.blockPalette[0];
            }
            if (this.blocks.length == 0) {
                return BlockState.AIR;
            }
            int blockIndex = (y &= 0xF) * 256 + (z &= 0xF) * 16 + (x &= 0xF);
            long value = MCAMath.getValueFromLongArray(this.blocks, blockIndex, this.bitsPerBlock);
            if (value >= (long)this.blockPalette.length) {
                Logger.global.noFloodWarning("palettewarning", "Got block-palette value " + value + " but palette has size of " + this.blockPalette.length + "! (Future occasions of this error will not be logged)");
                return BlockState.MISSING;
            }
            return this.blockPalette[(int)value];
        }

        public LightData getLightData(int x, int y, int z, LightData target) {
            if (this.blockLight.length == 0 && this.skyLight.length == 0) {
                return target.set(0, 0);
            }
            int blockByteIndex = (y &= 0xF) * 256 + (z &= 0xF) * 16 + (x &= 0xF);
            int blockHalfByteIndex = blockByteIndex >> 1;
            boolean largeHalf = (blockByteIndex & 1) != 0;
            return target.set(this.skyLight.length > 0 ? MCAMath.getByteHalf(this.skyLight[blockHalfByteIndex], largeHalf) : 0, this.blockLight.length > 0 ? MCAMath.getByteHalf(this.blockLight[blockHalfByteIndex], largeHalf) : 0);
        }

        public String getBiome(int x, int y, int z) {
            if (this.biomePalette.length == 0) {
                return Biome.DEFAULT.getValue();
            }
            if (this.biomePalette.length == 1 || this.biomes.length == 0) {
                return this.biomePalette[0];
            }
            int biomeIndex = (y = (y & 0xF) / 4) * 16 + (z = (z & 0xF) / 4) * 4 + (x = (x & 0xF) / 4);
            long value = MCAMath.getValueFromLongArray(this.biomes, biomeIndex, this.bitsPerBiome);
            if (value >= (long)this.biomePalette.length) {
                Logger.global.noFloodWarning("biomepalettewarning", "Got biome-palette value " + value + " but palette has size of " + this.biomePalette.length + "! (Future occasions of this error will not be logged)");
                return Biome.DEFAULT.getValue();
            }
            return this.biomePalette[(int)value];
        }
    }
}

