/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.mca;

import de.bluecolored.bluemap.core.mca.ChunkAnvil113;
import de.bluecolored.bluemap.core.mca.ChunkAnvil115;
import de.bluecolored.bluemap.core.mca.ChunkAnvil116;
import de.bluecolored.bluemap.core.mca.ChunkAnvil118;
import de.bluecolored.bluemap.core.mca.MCAWorld;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.shadow.querz.nbt.CompoundTag;
import java.io.IOException;

public abstract class MCAChunk
implements Chunk {
    private final MCAWorld world;
    private final int dataVersion;

    protected MCAChunk() {
        this.world = null;
        this.dataVersion = -1;
    }

    protected MCAChunk(MCAWorld world) {
        this.world = world;
        this.dataVersion = -1;
    }

    protected MCAChunk(MCAWorld world, CompoundTag chunkTag) {
        this.world = world;
        this.dataVersion = chunkTag.getInt("DataVersion");
    }

    @Override
    public abstract boolean isGenerated();

    public int getDataVersion() {
        return this.dataVersion;
    }

    @Override
    public abstract long getInhabitedTime();

    @Override
    public abstract BlockState getBlockState(int var1, int var2, int var3);

    @Override
    public abstract LightData getLightData(int var1, int var2, int var3, LightData var4);

    @Override
    public abstract String getBiome(int var1, int var2, int var3);

    @Override
    public int getMaxY(int x, int z) {
        return 255;
    }

    @Override
    public int getMinY(int x, int z) {
        return 0;
    }

    @Override
    public int getWorldSurfaceY(int x, int z) {
        return 0;
    }

    @Override
    public int getOceanFloorY(int x, int z) {
        return 0;
    }

    protected MCAWorld getWorld() {
        return this.world;
    }

    public static MCAChunk create(MCAWorld world, CompoundTag chunkTag) throws IOException {
        int version = chunkTag.getInt("DataVersion");
        if (version < 2200) {
            return new ChunkAnvil113(world, chunkTag);
        }
        if (version < 2500) {
            return new ChunkAnvil115(world, chunkTag);
        }
        if (version < 2844) {
            return new ChunkAnvil116(world, chunkTag);
        }
        return new ChunkAnvil118(world, chunkTag);
    }

    public String toString() {
        return "MCAChunk{world=" + this.world + "dataVersion=" + this.dataVersion + "isGenerated()=" + this.isGenerated() + "}";
    }
}

