/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.mca;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.mca.region.RegionType;
import de.bluecolored.bluemap.core.util.Vector2iCache;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.EmptyChunk;
import de.bluecolored.bluemap.core.world.Grid;
import de.bluecolored.bluemap.core.world.Region;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.shadow.benmanes.caffeine.cache.Caffeine;
import de.bluecolored.shadow.benmanes.caffeine.cache.LoadingCache;
import de.bluecolored.shadow.querz.nbt.CompoundTag;
import de.bluecolored.shadow.querz.nbt.NBTUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

@DebugDump
public class MCAWorld
implements World {
    private static final Grid CHUNK_GRID = new Grid(16);
    private static final Grid REGION_GRID = new Grid(32).multiply(CHUNK_GRID);
    private static final Vector2iCache VECTOR_2_I_CACHE = new Vector2iCache();
    private final Path worldFolder;
    private final String name;
    private final Vector3i spawnPoint;
    private final int skyLight;
    private final boolean ignoreMissingLightData;
    private final LoadingCache<Vector2i, Region> regionCache;
    private final LoadingCache<Vector2i, Chunk> chunkCache;

    public MCAWorld(Path worldFolder, int skyLight, boolean ignoreMissingLightData) throws IOException {
        this.worldFolder = worldFolder.toRealPath(new LinkOption[0]);
        this.skyLight = skyLight;
        this.ignoreMissingLightData = ignoreMissingLightData;
        this.regionCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build(this::loadRegion);
        this.chunkCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).maximumSize(500L).expireAfterWrite(1L, TimeUnit.MINUTES).build(this::loadChunk);
        try {
            Path levelFile = MCAWorld.resolveLevelFile(worldFolder);
            CompoundTag level = (CompoundTag)NBTUtil.readTag(levelFile.toFile());
            CompoundTag levelData = level.getCompoundTag("Data");
            this.name = levelData.getString("LevelName");
            this.spawnPoint = new Vector3i(levelData.getInt("SpawnX"), levelData.getInt("SpawnY"), levelData.getInt("SpawnZ"));
        }
        catch (ClassCastException | NullPointerException ex) {
            throw new IOException("Invalid level.dat format!", ex);
        }
    }

    @Override
    public Chunk getChunkAtBlock(int x, int y, int z) {
        return this.getChunk(x >> 4, z >> 4);
    }

    @Override
    public Chunk getChunk(int x, int z) {
        return this.getChunk(VECTOR_2_I_CACHE.get(x, z));
    }

    private Chunk getChunk(Vector2i pos) {
        return this.chunkCache.get(pos);
    }

    @Override
    public Region getRegion(int x, int z) {
        return this.getRegion(VECTOR_2_I_CACHE.get(x, z));
    }

    private Region getRegion(Vector2i pos) {
        return this.regionCache.get(pos);
    }

    @Override
    public Collection<Vector2i> listRegions() {
        File[] regionFiles = this.getRegionFolder().toFile().listFiles();
        if (regionFiles == null) {
            return Collections.emptyList();
        }
        ArrayList<Vector2i> regions = new ArrayList<Vector2i>(regionFiles.length);
        for (File file : regionFiles) {
            if (RegionType.forFileName(file.getName()) == null || file.length() <= 0L) continue;
            try {
                String[] filenameParts = file.getName().split("\\.");
                int rX = Integer.parseInt(filenameParts[1]);
                int rZ = Integer.parseInt(filenameParts[2]);
                regions.add(new Vector2i(rX, rZ));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return regions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Path getSaveFolder() {
        return this.worldFolder;
    }

    @Override
    public int getSkyLight() {
        return this.skyLight;
    }

    @Override
    public int getMinY(int x, int z) {
        return this.getChunk(x >> 4, z >> 4).getMinY(x, z);
    }

    @Override
    public int getMaxY(int x, int z) {
        return this.getChunk(x >> 4, z >> 4).getMaxY(x, z);
    }

    @Override
    public Grid getChunkGrid() {
        return CHUNK_GRID;
    }

    @Override
    public Grid getRegionGrid() {
        return REGION_GRID;
    }

    @Override
    public Vector3i getSpawnPoint() {
        return this.spawnPoint;
    }

    @Override
    public void invalidateChunkCache() {
        this.chunkCache.invalidateAll();
    }

    @Override
    public void invalidateChunkCache(int x, int z) {
        this.chunkCache.invalidate(VECTOR_2_I_CACHE.get(x, z));
    }

    @Override
    public void cleanUpChunkCache() {
        this.chunkCache.cleanUp();
    }

    public Path getWorldFolder() {
        return this.worldFolder;
    }

    private Path getRegionFolder() {
        return this.worldFolder.resolve("region");
    }

    public boolean isIgnoreMissingLightData() {
        return this.ignoreMissingLightData;
    }

    private Region loadRegion(Vector2i regionPos) {
        return this.loadRegion(regionPos.getX(), regionPos.getY());
    }

    Region loadRegion(int x, int z) {
        return RegionType.loadRegion(this, this.getRegionFolder(), x, z);
    }

    private Chunk loadChunk(Vector2i chunkPos) {
        return this.loadChunk(chunkPos.getX(), chunkPos.getY());
    }

    Chunk loadChunk(int x, int z) {
        int tries = 3;
        int tryInterval = 1000;
        Exception loadException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.getRegion(x >> 5, z >> 5).loadChunk(x, z, this.ignoreMissingLightData);
            }
            catch (IOException | RuntimeException e) {
                if (loadException != null) {
                    e.addSuppressed(loadException);
                }
                loadException = e;
                if (i + 1 >= 3) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        Logger.global.logDebug("Unexpected exception trying to load chunk (x:" + x + ", z:" + z + "):" + loadException);
        return EmptyChunk.INSTANCE;
    }

    public String toString() {
        return "MCAWorld{worldFolder=" + this.worldFolder + ", name='" + this.name + "', spawnPoint=" + this.spawnPoint + ", skyLight=" + this.skyLight + ", ignoreMissingLightData=" + this.ignoreMissingLightData + "}";
    }

    private static Path resolveLevelFile(Path worldFolder) throws IOException {
        Path levelFolder = worldFolder.toRealPath(new LinkOption[0]);
        Path levelFile = levelFolder.resolve("level.dat");
        for (int searchDepth = 0; !Files.isRegularFile(levelFile, new LinkOption[0]) && searchDepth < 4; ++searchDepth) {
            if ((levelFolder = levelFolder.getParent()) == null) break;
            levelFile = levelFolder.resolve("level.dat");
        }
        if (!Files.isRegularFile(levelFile, new LinkOption[0])) {
            throw new FileNotFoundException("Could not find a level.dat file for this world!");
        }
        return levelFile;
    }
}

