/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.mca.region;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.mca.MCAChunk;
import de.bluecolored.bluemap.core.mca.MCAWorld;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.EmptyChunk;
import de.bluecolored.bluemap.core.world.Region;
import de.bluecolored.shadow.airlift.compress.zstd.ZstdInputStream;
import de.bluecolored.shadow.querz.nbt.CompoundTag;
import de.bluecolored.shadow.querz.nbt.Tag;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LinearRegion
implements Region {
    public static final String FILE_SUFFIX = ".linear";
    private static final List<Byte> SUPPORTED_VERSIONS = Arrays.asList((byte)1, (byte)2);
    private static final long SUPERBLOCK = -4323716122432332390L;
    private static final int HEADER_SIZE = 32;
    private static final int FOOTER_SIZE = 8;
    private final MCAWorld world;
    private final Path regionFile;
    private final Vector2i regionPos;

    public LinearRegion(MCAWorld world, Path regionFile) throws IllegalArgumentException {
        this.world = world;
        this.regionFile = regionFile;
        String[] filenameParts = regionFile.getFileName().toString().split("\\.");
        int rX = Integer.parseInt(filenameParts[1]);
        int rZ = Integer.parseInt(filenameParts[2]);
        this.regionPos = new Vector2i(rX, rZ);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Chunk loadChunk(int chunkX, int chunkZ, boolean ignoreMissingLightData) throws IOException {
        if (Files.notExists(this.regionFile, new LinkOption[0])) {
            return EmptyChunk.INSTANCE;
        }
        long fileLength = Files.size(this.regionFile);
        if (fileLength == 0L) {
            return EmptyChunk.INSTANCE;
        }
        try (InputStream inputStream = Files.newInputStream(this.regionFile, new OpenOption[0]);
             DataInputStream rawDataStream = new DataInputStream(inputStream);){
            long superBlock = rawDataStream.readLong();
            if (superBlock != -4323716122432332390L) {
                throw new RuntimeException("Invalid superblock: " + superBlock + " file " + this.regionFile);
            }
            byte version = rawDataStream.readByte();
            if (!SUPPORTED_VERSIONS.contains(version)) {
                throw new RuntimeException("Invalid version: " + version + " file " + this.regionFile);
            }
            rawDataStream.skipBytes(11);
            int dataCount = rawDataStream.readInt();
            if (fileLength != (long)(32 + dataCount + 8)) {
                throw new RuntimeException("Invalid file length: " + this.regionFile + " " + fileLength + " " + (32 + dataCount + 8));
            }
            rawDataStream.skipBytes(8);
            byte[] rawCompressed = new byte[dataCount];
            rawDataStream.readFully(rawCompressed, 0, dataCount);
            superBlock = rawDataStream.readLong();
            if (superBlock != -4323716122432332390L) {
                throw new RuntimeException("Invalid footer superblock: " + this.regionFile);
            }
            try (DataInputStream dis = new DataInputStream(new ZstdInputStream(new ByteArrayInputStream(rawCompressed)));){
                String string;
                int x = chunkX - (this.regionPos.getX() << 5);
                int z = chunkZ - (this.regionPos.getY() << 5);
                int pos = (z << 5) + x;
                int skip = 0;
                for (int i = 0; i < pos; skip += dis.readInt(), ++i) {
                    dis.skipBytes(4);
                }
                int size = dis.readInt();
                if (size <= 0) {
                    Chunk chunk = EmptyChunk.INSTANCE;
                    return chunk;
                }
                dis.skipBytes((1024 - pos - 1 << 3) + 4);
                dis.skipBytes(skip);
                Tag<?> tag = Tag.deserialize(dis, 512);
                if (tag instanceof CompoundTag) {
                    MCAChunk chunk = MCAChunk.create(this.world, (CompoundTag)tag);
                    if (!chunk.isGenerated()) {
                        Chunk chunk2 = EmptyChunk.INSTANCE;
                        return chunk2;
                    }
                    MCAChunk mCAChunk = chunk;
                    return mCAChunk;
                }
                if (tag == null) {
                    string = "null";
                    throw new IOException("Invalid data tag: " + string);
                }
                string = tag.getClass().getName();
                throw new IOException("Invalid data tag: " + string);
            }
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<Vector2i> listChunks(long modifiedSince) {
        long fileLength;
        if (Files.notExists(this.regionFile, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            fileLength = Files.size(this.regionFile);
            if (fileLength == 0L) {
                return Collections.emptyList();
            }
        }
        catch (IOException ex) {
            Logger.global.logWarning("Failed to read file-size for file: " + this.regionFile);
            return Collections.emptyList();
        }
        ArrayList<Vector2i> chunks = new ArrayList<Vector2i>(1024);
        try (InputStream inputStream = Files.newInputStream(this.regionFile, new OpenOption[0]);
             DataInputStream rawDataStream = new DataInputStream(inputStream);){
            long superBlock = rawDataStream.readLong();
            if (superBlock != -4323716122432332390L) {
                throw new RuntimeException("Invalid superblock: " + superBlock + " file " + this.regionFile);
            }
            byte version = rawDataStream.readByte();
            if (!SUPPORTED_VERSIONS.contains(version)) {
                throw new RuntimeException("Invalid version: " + version + " file " + this.regionFile);
            }
            int date = (int)(modifiedSince / 1000L);
            long newestTimestamp = rawDataStream.readLong();
            if (newestTimestamp < (long)date) {
                List<Vector2i> list = Collections.emptyList();
                return list;
            }
            if (version == 1) {
                int i2 = 0;
                while (true) {
                    if (i2 >= 1024) {
                        ArrayList<Vector2i> i2 = chunks;
                        return i2;
                    }
                    chunks.add(new Vector2i((this.regionPos.getX() << 5) + (i2 & 0x1F), (this.regionPos.getY() << 5) + (i2 >> 5)));
                    ++i2;
                }
            }
            rawDataStream.skipBytes(3);
            int dataCount = rawDataStream.readInt();
            if (fileLength != (long)(32 + dataCount + 8)) {
                throw new RuntimeException("Invalid file length: " + this.regionFile + " " + fileLength + " " + (32 + dataCount + 8));
            }
            rawDataStream.skipBytes(8);
            byte[] rawCompressed = new byte[dataCount];
            rawDataStream.readFully(rawCompressed, 0, dataCount);
            superBlock = rawDataStream.readLong();
            if (superBlock != -4323716122432332390L) {
                throw new RuntimeException("Invalid footer SuperBlock: " + this.regionFile);
            }
            try (DataInputStream dis = new DataInputStream(new ZstdInputStream(new ByteArrayInputStream(rawCompressed)));){
                int i = 0;
                while (i < 1024) {
                    dis.skipBytes(4);
                    int timestamp = dis.readInt();
                    if (timestamp >= date) {
                        chunks.add(new Vector2i((this.regionPos.getX() << 5) + (i & 0x1F), (this.regionPos.getY() << 5) + (i >> 5)));
                    }
                    ++i;
                }
                return chunks;
            }
        }
        catch (IOException | RuntimeException ex) {
            Logger.global.logWarning("Failed to read .linear file: " + this.regionFile + " (" + ex + ")");
        }
        return chunks;
    }

    @Override
    public Path getRegionFile() {
        return this.regionFile;
    }

    public static String getRegionFileName(int regionX, int regionZ) {
        return "r." + regionX + "." + regionZ + FILE_SUFFIX;
    }
}

