/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.mca.region;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.mca.MCAChunk;
import de.bluecolored.bluemap.core.mca.MCAWorld;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.EmptyChunk;
import de.bluecolored.bluemap.core.world.Region;
import de.bluecolored.shadow.querz.nbt.CompoundTag;
import de.bluecolored.shadow.querz.nbt.Tag;
import de.bluecolored.shadow.querz.nbt.mca.CompressionType;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class MCARegion
implements Region {
    public static final String FILE_SUFFIX = ".mca";
    private final MCAWorld world;
    private final Path regionFile;
    private final Vector2i regionPos;

    public MCARegion(MCAWorld world, Path regionFile) throws IllegalArgumentException {
        this.world = world;
        this.regionFile = regionFile;
        String[] filenameParts = regionFile.getFileName().toString().split("\\.");
        int rX = Integer.parseInt(filenameParts[1]);
        int rZ = Integer.parseInt(filenameParts[2]);
        this.regionPos = new Vector2i(rX, rZ);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Chunk loadChunk(int chunkX, int chunkZ, boolean ignoreMissingLightData) throws IOException {
        if (Files.notExists(this.regionFile, new LinkOption[0])) {
            return EmptyChunk.INSTANCE;
        }
        long fileLength = Files.size(this.regionFile);
        if (fileLength == 0L) {
            return EmptyChunk.INSTANCE;
        }
        try (RandomAccessFile raf = new RandomAccessFile(this.regionFile.toFile(), "r");){
            String string;
            CompressionType compressionType;
            int xzChunk = Math.floorMod(chunkZ, 32) * 32 + Math.floorMod(chunkX, 32);
            raf.seek((long)xzChunk * 4L);
            int offset = raf.read() << 16;
            offset |= (raf.read() & 0xFF) << 8;
            offset |= raf.read() & 0xFF;
            offset *= 4096;
            int size = raf.readByte() * 4096;
            if (size == 0) {
                Chunk chunk = EmptyChunk.INSTANCE;
                return chunk;
            }
            raf.seek(offset + 4);
            byte compressionTypeByte = raf.readByte();
            CompressionType compressionType2 = compressionType = compressionTypeByte == 3 ? CompressionType.NONE : CompressionType.getFromID(compressionTypeByte);
            if (compressionType == null) {
                throw new IOException("Invalid compression type " + compressionTypeByte);
            }
            DataInputStream dis = new DataInputStream(new BufferedInputStream(compressionType.decompress(new FileInputStream(raf.getFD()))));
            Tag<?> tag = Tag.deserialize(dis, 512);
            if (tag instanceof CompoundTag) {
                MCAChunk chunk = MCAChunk.create(this.world, (CompoundTag)tag);
                if (!chunk.isGenerated()) {
                    Chunk chunk2 = EmptyChunk.INSTANCE;
                    return chunk2;
                }
                MCAChunk mCAChunk = chunk;
                return mCAChunk;
            }
            if (tag == null) {
                string = "null";
                throw new IOException("Invalid data tag: " + string);
            }
            string = tag.getClass().getName();
            throw new IOException("Invalid data tag: " + string);
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<Vector2i> listChunks(long modifiedSince) {
        if (Files.notExists(this.regionFile, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            long fileLength = Files.size(this.regionFile);
            if (fileLength == 0L) {
                return Collections.emptyList();
            }
        }
        catch (IOException ex) {
            Logger.global.logWarning("Failed to read file-size for file: " + this.regionFile);
            return Collections.emptyList();
        }
        ArrayList<Vector2i> chunks = new ArrayList<Vector2i>(1024);
        try (RandomAccessFile raf = new RandomAccessFile(this.regionFile.toFile(), "r");){
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    Vector2i chunk = new Vector2i(this.regionPos.getX() * 32 + x, this.regionPos.getY() * 32 + z);
                    int xzChunk = z * 32 + x;
                    raf.seek(xzChunk * 4 + 3);
                    int size = raf.readByte() * 4096;
                    if (size == 0) continue;
                    raf.seek(xzChunk * 4 + 4096);
                    int timestamp = raf.read() << 24;
                    timestamp |= (raf.read() & 0xFF) << 16;
                    timestamp |= (raf.read() & 0xFF) << 8;
                    if ((long)(timestamp |= raf.read() & 0xFF) < modifiedSince / 1000L) continue;
                    chunks.add(chunk);
                }
            }
        }
        catch (IOException | RuntimeException ex) {
            Logger.global.logWarning("Failed to read .mca file: " + this.regionFile + " (" + ex + ")");
        }
        return chunks;
    }

    @Override
    public Path getRegionFile() {
        return this.regionFile;
    }

    public static String getRegionFileName(int regionX, int regionZ) {
        return "r." + regionX + "." + regionZ + FILE_SUFFIX;
    }
}

