/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources;

import com.google.gson.stream.JsonReader;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.resources.BlockStateMapping;
import de.bluecolored.bluemap.core.world.BlockProperties;
import de.bluecolored.bluemap.core.world.BlockState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@DebugDump
public class BlockPropertiesConfig {
    private final Map<String, List<BlockStateMapping<BlockProperties>>> mappings = new ConcurrentHashMap<String, List<BlockStateMapping<BlockProperties>>>();

    public void load(Path configFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(configFile);){
            JsonReader json = new JsonReader((Reader)reader);
            json.setLenient(true);
            json.beginObject();
            while (json.hasNext()) {
                String formatted = json.nextName();
                BlockState bsKey = BlockState.fromString(formatted);
                BlockProperties.Builder bsValueBuilder = BlockProperties.builder();
                json.beginObject();
                while (json.hasNext()) {
                    switch (json.nextName()) {
                        case "culling": {
                            bsValueBuilder.culling(json.nextBoolean());
                            break;
                        }
                        case "occluding": {
                            bsValueBuilder.occluding(json.nextBoolean());
                            break;
                        }
                        case "alwaysWaterlogged": {
                            bsValueBuilder.alwaysWaterlogged(json.nextBoolean());
                            break;
                        }
                        case "randomOffset": {
                            bsValueBuilder.randomOffset(json.nextBoolean());
                            break;
                        }
                        case "cullingIdentical": {
                            bsValueBuilder.cullingIdentical(json.nextBoolean());
                            break;
                        }
                    }
                }
                json.endObject();
                BlockStateMapping<BlockProperties> mapping = new BlockStateMapping<BlockProperties>(bsKey, bsValueBuilder.build());
                this.mappings.computeIfAbsent(bsKey.getFormatted(), k -> new LinkedList()).add(mapping);
            }
            json.endObject();
        }
    }

    public BlockProperties getBlockProperties(BlockState from) {
        for (BlockStateMapping bm : this.mappings.getOrDefault(from.getFormatted(), Collections.emptyList())) {
            if (!bm.fitsTo(from)) continue;
            return (BlockProperties)bm.getMapping();
        }
        return BlockProperties.DEFAULT;
    }
}

