/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.core.util.math.Color;
import java.io.IOException;

public class ColorAdapter
extends TypeAdapter<Color> {
    public void write(JsonWriter out, Color value) throws IOException {
        value.straight();
        out.beginArray();
        out.value((double)value.r);
        out.value((double)value.g);
        out.value((double)value.b);
        out.value((double)value.a);
        out.endArray();
    }

    public Color read(JsonReader in) throws IOException {
        Color value = new Color();
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                in.beginArray();
                value.set((float)in.nextDouble(), (float)in.nextDouble(), (float)in.nextDouble(), in.hasNext() ? (float)in.nextDouble() : 1.0f, false);
                in.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                value.a = 1.0f;
                in.beginObject();
                while (in.hasNext()) {
                    String n = in.nextName();
                    float v = (float)in.nextDouble();
                    switch (n) {
                        case "r": {
                            value.r = v;
                            break;
                        }
                        case "g": {
                            value.g = v;
                            break;
                        }
                        case "b": {
                            value.b = v;
                            break;
                        }
                        case "a": {
                            value.a = v;
                        }
                    }
                }
                in.endObject();
                break;
            }
            case STRING: {
                value.parse(in.nextString());
                break;
            }
            case NUMBER: {
                int color = in.nextInt();
                if ((color & 0xFF000000) == 0) {
                    color |= 0xFF000000;
                }
                value.set(color);
                break;
            }
            case NULL: {
                break;
            }
            default: {
                throw new IOException("Unexpected token while parsing Color:" + token);
            }
        }
        return value;
    }
}

