/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.resourcepack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.BlockColorCalculatorFactory;
import de.bluecolored.bluemap.core.resources.BlockPropertiesConfig;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.resources.biome.BiomeConfig;
import de.bluecolored.bluemap.core.resources.resourcepack.blockmodel.BlockModel;
import de.bluecolored.bluemap.core.resources.resourcepack.blockmodel.TextureVariable;
import de.bluecolored.bluemap.core.resources.resourcepack.blockstate.BlockState;
import de.bluecolored.bluemap.core.resources.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Tristate;
import de.bluecolored.bluemap.core.world.Biome;
import de.bluecolored.bluemap.core.world.BlockProperties;
import de.bluecolored.shadow.benmanes.caffeine.cache.Caffeine;
import de.bluecolored.shadow.benmanes.caffeine.cache.LoadingCache;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

@DebugDump
public class ResourcePack {
    public static final ResourcePath<BlockState> MISSING_BLOCK_STATE = new ResourcePath("bluemap", "missing");
    public static final ResourcePath<BlockModel> MISSING_BLOCK_MODEL = new ResourcePath("bluemap", "block/missing");
    public static final ResourcePath<Texture> MISSING_TEXTURE = new ResourcePath("bluemap", "block/missing");
    private final Map<String, ResourcePath<BlockState>> blockStatePaths = new HashMap<String, ResourcePath<BlockState>>();
    private final Map<ResourcePath<BlockState>, BlockState> blockStates = new HashMap<ResourcePath<BlockState>, BlockState>();
    private final Map<String, ResourcePath<BlockModel>> blockModelPaths = new HashMap<String, ResourcePath<BlockModel>>();
    private final Map<ResourcePath<BlockModel>, BlockModel> blockModels = new HashMap<ResourcePath<BlockModel>, BlockModel>();
    private final Map<String, ResourcePath<Texture>> texturePaths = new HashMap<String, ResourcePath<Texture>>();
    private final Map<ResourcePath<Texture>, Texture> textures = new HashMap<ResourcePath<Texture>, Texture>();
    private final Map<ResourcePath<BufferedImage>, BufferedImage> colormaps = new HashMap<ResourcePath<BufferedImage>, BufferedImage>();
    private final BlockColorCalculatorFactory colorCalculatorFactory = new BlockColorCalculatorFactory();
    private final BiomeConfig biomeConfig = new BiomeConfig();
    private final BlockPropertiesConfig blockPropertiesConfig = new BlockPropertiesConfig();
    private final LoadingCache<de.bluecolored.bluemap.core.world.BlockState, BlockProperties> blockPropertiesCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).maximumSize(10000L).build(this::loadBlockProperties);

    @Nullable
    public ResourcePath<BlockState> getBlockStatePath(String formatted) {
        return this.blockStatePaths.get(formatted);
    }

    @Nullable
    public BlockState getBlockState(de.bluecolored.bluemap.core.world.BlockState blockState) {
        ResourcePath<BlockState> path = this.blockStatePaths.get(blockState.getFormatted());
        return path != null ? path.getResource(this::getBlockState) : MISSING_BLOCK_STATE.getResource(this::getBlockState);
    }

    @Nullable
    public BlockState getBlockState(ResourcePath<BlockState> path) {
        BlockState blockState = this.blockStates.get(path);
        return blockState != null ? blockState : MISSING_BLOCK_STATE.getResource(this.blockStates::get);
    }

    public Map<ResourcePath<BlockState>, BlockState> getBlockStates() {
        return this.blockStates;
    }

    @Nullable
    public ResourcePath<BlockModel> getBlockModelPath(String formatted) {
        return this.blockModelPaths.get(formatted);
    }

    @Nullable
    public BlockModel getBlockModel(ResourcePath<BlockModel> path) {
        BlockModel blockModel = this.blockModels.get(path);
        return blockModel != null ? blockModel : MISSING_BLOCK_MODEL.getResource(this.blockModels::get);
    }

    public Map<ResourcePath<BlockModel>, BlockModel> getBlockModels() {
        return this.blockModels;
    }

    @Nullable
    public ResourcePath<Texture> getTexturePath(String formatted) {
        return this.texturePaths.get(formatted);
    }

    @Nullable
    public Texture getTexture(ResourcePath<Texture> path) {
        Texture texture = this.textures.get(path);
        return texture != null ? texture : MISSING_TEXTURE.getResource(this.textures::get);
    }

    public Map<ResourcePath<Texture>, Texture> getTextures() {
        return this.textures;
    }

    public BlockColorCalculatorFactory getColorCalculatorFactory() {
        return this.colorCalculatorFactory;
    }

    public Biome getBiome(String formatted) {
        return this.biomeConfig.getBiome(formatted);
    }

    public BlockProperties getBlockProperties(de.bluecolored.bluemap.core.world.BlockState state) {
        return this.blockPropertiesCache.get(state);
    }

    private BlockProperties loadBlockProperties(de.bluecolored.bluemap.core.world.BlockState state) {
        BlockState resource;
        BlockProperties.Builder props = this.blockPropertiesConfig.getBlockProperties(state).toBuilder();
        if ((props.isOccluding() == Tristate.UNDEFINED || props.isCulling() == Tristate.UNDEFINED) && (resource = this.getBlockState(state)) != null) {
            resource.forEach(state, 0, 0, 0, variant -> {
                BlockModel model = variant.getModel().getResource(this::getBlockModel);
                if (model != null) {
                    if (props.isOccluding() == Tristate.UNDEFINED) {
                        props.occluding(model.isOccluding());
                    }
                    if (props.isCulling() == Tristate.UNDEFINED) {
                        props.culling(model.isCulling());
                    }
                }
            });
        }
        return props.build();
    }

    public synchronized void loadResources(Iterable<Path> roots) throws IOException {
        Logger.global.logInfo("Loading resources...");
        for (Path root : roots) {
            Logger.global.logDebug("Loading resources from: " + root + " ...");
            this.loadResourcePath(root, this::loadResources);
        }
        Logger.global.logInfo("Loading textures...");
        for (Path root : roots) {
            Logger.global.logDebug("Loading textures from: " + root + " ...");
            this.loadResourcePath(root, this::loadTextures);
        }
        Logger.global.logInfo("Baking resources...");
        this.bake();
        Logger.global.logInfo("Resources loaded.");
    }

    private void loadResourcePath(Path root, PathLoader resourceLoader) throws IOException {
        if (!Files.isDirectory(root, new LinkOption[0])) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(root, (ClassLoader)null);){
                for (Path fsRoot : fileSystem.getRootDirectories()) {
                    if (!Files.isDirectory(fsRoot, new LinkOption[0])) continue;
                    this.loadResourcePath(fsRoot, resourceLoader);
                }
            }
            catch (Exception ex) {
                Logger.global.logDebug("Failed to read '" + root + "': " + ex);
            }
            return;
        }
        Path fabricModJson = root.resolve("fabric.mod.json");
        if (Files.isRegularFile(fabricModJson, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(fabricModJson);){
                JsonObject rootElement = (JsonObject)ResourcesGson.INSTANCE.fromJson((Reader)reader, JsonObject.class);
                if (rootElement.has("jars")) {
                    for (JsonElement element : rootElement.getAsJsonArray("jars")) {
                        Path file = root.resolve(element.getAsJsonObject().get("file").getAsString());
                        if (!Files.exists(file, new LinkOption[0])) continue;
                        this.loadResourcePath(file, resourceLoader);
                    }
                }
            }
            catch (Exception ex) {
                Logger.global.logDebug("Failed to read fabric.mod.json: " + ex);
            }
        }
        resourceLoader.load(root);
    }

    private void loadResources(Path root) throws IOException {
        try {
            CompletableFuture.allOf(CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("blockstates")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(ResourcePack::walk).filter(path -> path.getFileName().toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.loadResource(root, (Path)file, () -> {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    BlockState blockState = (BlockState)ResourcesGson.INSTANCE.fromJson((Reader)reader, BlockState.class);
                    return blockState;
                }
            }, (Map)this.blockStates)), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("models")).flatMap(ResourcePack::list).filter(path -> !path.getFileName().toString().equals("item")).flatMap(ResourcePack::walk).filter(path -> path.getFileName().toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.loadResource(root, (Path)file, () -> {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    BlockModel blockModel = (BlockModel)ResourcesGson.INSTANCE.fromJson((Reader)reader, BlockModel.class);
                    return blockModel;
                }
            }, (Map)this.blockModels)), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.walk(root.resolve("assets").resolve("minecraft").resolve("textures").resolve("colormap")).filter(path -> path.getFileName().toString().endsWith(".png")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.loadResource(root, (Path)file, () -> {
                try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                    BufferedImage bufferedImage = ImageIO.read(in);
                    return bufferedImage;
                }
            }, (Map)this.colormaps)), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("blockColors.json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    this.colorCalculatorFactory.load((Path)file);
                }
                catch (Exception ex) {
                    Logger.global.logDebug("Failed to parse resource-file '" + file + "': " + ex);
                }
            }), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> {
                ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("biomes.json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    try {
                        this.biomeConfig.load((Path)file);
                    }
                    catch (Exception ex) {
                        Logger.global.logDebug("Failed to parse resource-file '" + file + "': " + ex);
                    }
                });
                ResourcePack.list(root.resolve("data")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(namespace -> ResourcePack.list(namespace.resolve("worldgen").resolve("biome")).filter(path -> path.getFileName().toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    try {
                        this.biomeConfig.loadDatapackBiome(namespace.getFileName().toString(), (Path)file);
                    }
                    catch (Exception ex) {
                        Logger.global.logDebug("Failed to parse resource-file '" + file + "': " + ex);
                    }
                }));
            }, BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("blockProperties.json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    this.blockPropertiesConfig.load((Path)file);
                }
                catch (Exception ex) {
                    Logger.global.logDebug("Failed to parse resource-file '" + file + "': " + ex);
                }
            }), BlueMap.THREAD_POOL)).join();
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause != null) {
                throw new IOException(cause);
            }
            throw new IOException(ex);
        }
    }

    private void loadTextures(Path root) throws IOException {
        try {
            HashSet<ResourcePath<Texture>> usedTextures = new HashSet<ResourcePath<Texture>>();
            usedTextures.add(MISSING_TEXTURE);
            for (BlockModel model : this.blockModels.values()) {
                for (TextureVariable textureVariable : model.getTextures().values()) {
                    if (textureVariable.isReference()) continue;
                    usedTextures.add(textureVariable.getTexturePath());
                }
            }
            ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("textures")).flatMap(ResourcePack::walk).filter(path -> path.getFileName().toString().endsWith(".png")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.loadResource(root, (Path)file, () -> {
                ResourcePath<Texture> resourcePath = new ResourcePath<Texture>(root.relativize((Path)file));
                if (!usedTextures.contains(resourcePath)) {
                    return null;
                }
                try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                    Texture texture = Texture.from(resourcePath, ImageIO.read(in), Files.exists(file.resolveSibling(file.getFileName() + ".mcmeta"), new LinkOption[0]));
                    return texture;
                }
            }, (Map)this.textures));
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause != null) {
                throw new IOException(cause);
            }
            throw new IOException(ex);
        }
    }

    private void bake() throws IOException {
        this.blockStates.keySet().forEach(path -> this.blockStatePaths.put(path.getFormatted(), (ResourcePath<BlockState>)path));
        this.blockModels.keySet().forEach(path -> this.blockModelPaths.put(path.getFormatted(), (ResourcePath<BlockModel>)path));
        this.textures.keySet().forEach(path -> this.texturePaths.put(path.getFormatted(), (ResourcePath<Texture>)path));
        for (BlockModel model : this.blockModels.values()) {
            model.optimize(this);
        }
        for (BlockModel model : this.blockModels.values()) {
            model.applyParent(this);
        }
        for (BlockModel model : this.blockModels.values()) {
            model.calculateProperties(this);
        }
        BufferedImage foliage = new ResourcePath<BufferedImage>("minecraft:colormap/foliage").getResource(this.colormaps::get);
        if (foliage == null) {
            throw new IOException("Failed to bake resource-pack: No foliage-colormap found!");
        }
        this.colorCalculatorFactory.setFoliageMap(foliage);
        BufferedImage grass = new ResourcePath<BufferedImage>("minecraft:colormap/grass").getResource(this.colormaps::get);
        if (grass == null) {
            throw new IOException("Failed to bake resource-pack: No grass-colormap found!");
        }
        this.colorCalculatorFactory.setGrassMap(grass);
    }

    private <T> void loadResource(Path root, Path file, Loader<T> loader, Map<ResourcePath<T>, T> resultMap) {
        try {
            ResourcePath<T> resourcePath = new ResourcePath<T>(root.relativize(file));
            if (resultMap.containsKey(resourcePath)) {
                return;
            }
            T resource = loader.load();
            if (resource == null) {
                return;
            }
            resourcePath.setResource(resource);
            resultMap.put(resourcePath, resource);
        }
        catch (Exception ex) {
            Logger.global.logDebug("Failed to parse resource-file '" + file + "': " + ex);
        }
    }

    private static Stream<Path> list(Path root) {
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return Stream.empty();
        }
        try {
            return Files.list(root);
        }
        catch (IOException ex) {
            throw new CompletionException(ex);
        }
    }

    private static Stream<Path> walk(Path root) {
        if (!Files.exists(root, new LinkOption[0])) {
            return Stream.empty();
        }
        if (Files.isRegularFile(root, new LinkOption[0])) {
            return Stream.of(root);
        }
        try {
            return Files.walk(root, new FileVisitOption[0]);
        }
        catch (IOException ex) {
            throw new CompletionException(ex);
        }
    }

    private static interface PathLoader {
        public void load(Path var1) throws IOException;
    }

    private static interface Loader<T> {
        public T load() throws IOException;
    }
}

