/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage;

import de.bluecolored.shadow.airlift.compress.zstd.ZstdInputStream;
import de.bluecolored.shadow.airlift.compress.zstd.ZstdOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.zip.DeflaterInputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public enum Compression {
    NONE("none", "", out -> out, in -> in),
    GZIP("gzip", ".gz", GZIPOutputStream::new, GZIPInputStream::new),
    DEFLATE("deflate", ".deflate", DeflaterOutputStream::new, DeflaterInputStream::new),
    ZSTD("zstd", ".zst", ZstdOutputStream::new, ZstdInputStream::new);

    private final String typeId;
    private final String fileSuffix;
    private final StreamTransformer<OutputStream> compressor;
    private final StreamTransformer<InputStream> decompressor;

    private Compression(String typeId, String fileSuffix, StreamTransformer<OutputStream> compressor, StreamTransformer<InputStream> decompressor) {
        this.fileSuffix = fileSuffix;
        this.typeId = typeId;
        this.compressor = compressor;
        this.decompressor = decompressor;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public OutputStream compress(OutputStream out) throws IOException {
        return this.compressor.apply(out);
    }

    public InputStream decompress(InputStream in) throws IOException {
        return this.decompressor.apply(in);
    }

    public static Compression forTypeId(String id) {
        for (Compression compression : Compression.values()) {
            if (!compression.typeId.equals(id)) continue;
            return compression;
        }
        throw new NoSuchElementException("There is no Compression with type-id: " + id);
    }

    @FunctionalInterface
    private static interface StreamTransformer<T> {
        public T apply(T var1) throws IOException;
    }
}

