/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.sql;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.storage.CompressedInputStream;
import de.bluecolored.bluemap.core.storage.Compression;
import de.bluecolored.bluemap.core.storage.MetaInfo;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.storage.TileInfo;
import de.bluecolored.bluemap.core.storage.sql.SQLDriverException;
import de.bluecolored.bluemap.core.storage.sql.SQLStorageSettings;
import de.bluecolored.bluemap.core.storage.sql.dialect.Dialect;
import de.bluecolored.bluemap.core.storage.sql.dialect.DialectType;
import de.bluecolored.bluemap.core.util.WrappedOutputStream;
import de.bluecolored.shadow.apache.commons.dbcp2.ConnectionFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.DriverConnectionFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.DriverManagerConnectionFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.PoolableConnection;
import de.bluecolored.shadow.apache.commons.dbcp2.PoolableConnectionFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.PoolingDataSource;
import de.bluecolored.shadow.apache.commons.pool2.impl.GenericObjectPool;
import de.bluecolored.shadow.apache.commons.pool2.impl.GenericObjectPoolConfig;
import de.bluecolored.shadow.benmanes.caffeine.cache.Caffeine;
import de.bluecolored.shadow.benmanes.caffeine.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import javax.sql.DataSource;
import org.intellij.lang.annotations.Language;

public abstract class SQLStorage
extends Storage {
    private final DataSource dataSource;
    protected final Dialect dialect;
    protected final Compression hiresCompression;
    private final LoadingCache<String, Integer> mapFKs;
    private final LoadingCache<Compression, Integer> mapTileCompressionFKs;
    private volatile boolean closed;

    public SQLStorage(Dialect dialect, SQLStorageSettings config) throws MalformedURLException, SQLDriverException {
        block6: {
            this.mapFKs = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).build(this::loadMapFK);
            this.mapTileCompressionFKs = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).build(this::loadMapTileCompressionFK);
            this.dialect = dialect;
            this.closed = false;
            try {
                if (config.getDriverClass().isPresent()) {
                    if (config.getDriverJar().isPresent()) {
                        Driver driver;
                        URLClassLoader classLoader = new URLClassLoader(new URL[]{config.getDriverJar().get()});
                        Class<?> driverClass = Class.forName(config.getDriverClass().get(), true, classLoader);
                        try {
                            driver = (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception ex) {
                            throw new SQLDriverException("Failed to create an instance of the driver-class", ex);
                        }
                        this.dataSource = this.createDataSource(config.getConnectionUrl(), config.getConnectionProperties(), config.getMaxConnections(), driver);
                        break block6;
                    }
                    Class.forName(config.getDriverClass().get());
                    this.dataSource = this.createDataSource(config.getConnectionUrl(), config.getConnectionProperties(), config.getMaxConnections());
                    break block6;
                }
                this.dataSource = this.createDataSource(config.getConnectionUrl(), config.getConnectionProperties(), config.getMaxConnections());
            }
            catch (ClassNotFoundException ex) {
                throw new SQLDriverException("The driver-class does not exist.", ex);
            }
        }
        this.hiresCompression = config.getCompression();
    }

    @Override
    public OutputStream writeMapTile(String mapId, int lod, Vector2i tile) throws IOException {
        Compression compression = lod == 0 ? this.hiresCompression : Compression.NONE;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        return new WrappedOutputStream(compression.compress(byteOut), () -> {
            int mapFK = this.getMapFK(mapId);
            int tileCompressionFK = this.getMapTileCompressionFK(compression);
            this.recoveringConnection((Connection connection) -> {
                Blob dataBlob = connection.createBlob();
                try {
                    try (OutputStream blobOut = dataBlob.setBinaryStream(1L);){
                        byteOut.writeTo(blobOut);
                    }
                    this.executeUpdate(connection, this.dialect.writeMapTile(), mapFK, lod, tile.getX(), tile.getY(), tileCompressionFK, dataBlob);
                }
                finally {
                    dataBlob.free();
                }
            }, 2);
        });
    }

    @Override
    public Optional<CompressedInputStream> readMapTile(String mapId, int lod, Vector2i tile) throws IOException {
        Compression compression = lod == 0 ? this.hiresCompression : Compression.NONE;
        try {
            byte[] data = this.recoveringConnection((Connection connection) -> {
                ResultSet result = this.executeQuery(connection, this.dialect.readMapTile(), mapId, lod, tile.getX(), tile.getY(), compression.getTypeId());
                if (result.next()) {
                    Blob dataBlob = result.getBlob("data");
                    return dataBlob.getBytes(1L, (int)dataBlob.length());
                }
                return null;
            }, 2);
            if (data == null) {
                return Optional.empty();
            }
            return Optional.of(new CompressedInputStream(new ByteArrayInputStream(data), compression));
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public Optional<TileInfo> readMapTileInfo(final String mapId, final int lod, final Vector2i tile) throws IOException {
        final Compression compression = lod == 0 ? this.hiresCompression : Compression.NONE;
        try {
            TileInfo tileInfo = this.recoveringConnection((Connection connection) -> {
                ResultSet result = this.executeQuery(connection, this.dialect.readMapTileInfo(), mapId, lod, tile.getX(), tile.getY(), compression.getTypeId());
                if (result.next()) {
                    final long lastModified = result.getTimestamp("changed").getTime();
                    final long size = result.getLong("size");
                    return new TileInfo(){

                        @Override
                        public CompressedInputStream readMapTile() throws IOException {
                            return SQLStorage.this.readMapTile(mapId, lod, tile).orElseThrow(() -> new IOException("Tile no longer present!"));
                        }

                        @Override
                        public Compression getCompression() {
                            return compression;
                        }

                        @Override
                        public long getSize() {
                            return size;
                        }

                        @Override
                        public long getLastModified() {
                            return lastModified;
                        }
                    };
                }
                return null;
            }, 2);
            return Optional.ofNullable(tileInfo);
        }
        catch (SQLException | NoSuchElementException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void deleteMapTile(String mapId, int lod, Vector2i tile) throws IOException {
        try {
            this.recoveringConnection((Connection connection) -> this.executeUpdate(connection, this.dialect.deleteMapTile(), mapId, lod, tile.getX(), tile.getY()), 2);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public OutputStream writeMeta(String mapId, String name) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        return new WrappedOutputStream(byteOut, () -> {
            int mapFK = this.getMapFK(mapId);
            this.recoveringConnection((Connection connection) -> {
                Blob dataBlob = connection.createBlob();
                try {
                    try (OutputStream blobOut = dataBlob.setBinaryStream(1L);){
                        byteOut.writeTo(blobOut);
                    }
                    this.executeUpdate(connection, this.dialect.writeMeta(), mapFK, SQLStorage.escapeMetaName(name), dataBlob);
                }
                finally {
                    dataBlob.free();
                }
            }, 2);
        });
    }

    @Override
    public Optional<InputStream> readMeta(String mapId, String name) throws IOException {
        try {
            byte[] data = this.recoveringConnection((Connection connection) -> {
                ResultSet result = this.executeQuery(connection, this.dialect.readMeta(), mapId, SQLStorage.escapeMetaName(name));
                if (result.next()) {
                    Blob dataBlob = result.getBlob("value");
                    return dataBlob.getBytes(1L, (int)dataBlob.length());
                }
                return null;
            }, 2);
            if (data == null) {
                return Optional.empty();
            }
            return Optional.of(new CompressedInputStream(new ByteArrayInputStream(data), Compression.NONE));
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public Optional<MetaInfo> readMetaInfo(final String mapId, final String name) throws IOException {
        try {
            MetaInfo tileInfo = this.recoveringConnection((Connection connection) -> {
                ResultSet result = this.executeQuery(connection, this.dialect.readMetaSize(), mapId, SQLStorage.escapeMetaName(name));
                if (result.next()) {
                    final long size = result.getLong("size");
                    return new MetaInfo(){

                        @Override
                        public InputStream readMeta() throws IOException {
                            return SQLStorage.this.readMeta(mapId, name).orElseThrow(() -> new IOException("Tile no longer present!"));
                        }

                        @Override
                        public long getSize() {
                            return size;
                        }
                    };
                }
                return null;
            }, 2);
            return Optional.ofNullable(tileInfo);
        }
        catch (SQLException | NoSuchElementException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void deleteMeta(String mapId, String name) throws IOException {
        try {
            this.recoveringConnection((Connection connection) -> this.executeUpdate(connection, this.dialect.deleteMeta(), mapId, SQLStorage.escapeMetaName(name)), 2);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeMap(String mapId, Function<Storage.ProgressInfo, Boolean> onProgress) throws IOException {
        LoadingCache<String, Integer> loadingCache = this.mapFKs;
        synchronized (loadingCache) {
            try {
                this.recoveringConnection((Connection connection) -> {
                    this.executeUpdate(connection, this.dialect.purgeMapTile(), mapId);
                    this.executeUpdate(connection, this.dialect.purgeMapMeta(), mapId);
                    this.executeUpdate(connection, this.dialect.purgeMap(), mapId);
                }, 2);
                this.mapFKs.invalidate(mapId);
            }
            catch (SQLException ex) {
                throw new IOException(ex);
            }
        }
    }

    @Override
    public Collection<String> collectMapIds() throws IOException {
        try {
            return this.recoveringConnection((Connection connection) -> {
                ResultSet result = this.executeQuery(connection, this.dialect.selectMapIds(), new Object[0]);
                ArrayList<String> mapIds = new ArrayList<String>();
                while (result.next()) {
                    mapIds.add(result.getString("map_id"));
                }
                return mapIds;
            }, 2);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void initialize() throws IOException {
        try {
            int schemaVersion;
            String schemaVersionString = this.recoveringConnection((Connection connection) -> {
                connection.createStatement().executeUpdate(this.dialect.initializeStorageMeta());
                ResultSet result = this.executeQuery(connection, this.dialect.selectStorageMeta(), "schema_version");
                if (result.next()) {
                    return result.getString("value");
                }
                this.executeUpdate(connection, this.dialect.insertStorageMeta(), "schema_version", "0");
                return "0";
            }, 2);
            try {
                schemaVersion = Integer.parseInt(schemaVersionString);
            }
            catch (NumberFormatException ex) {
                throw new IOException("Invalid schema-version number: " + schemaVersionString, ex);
            }
            if (schemaVersion < 0 || schemaVersion > 3) {
                throw new IOException("Unknown schema-version: " + schemaVersion);
            }
            if (schemaVersion == 0) {
                Logger.global.logInfo("Initializing database-schema...");
                this.recoveringConnection((Connection connection) -> {
                    connection.createStatement().executeUpdate(this.dialect.initializeMap());
                    connection.createStatement().executeUpdate(this.dialect.initializeMapTileCompression());
                    connection.createStatement().executeUpdate(this.dialect.initializeMapMeta());
                    connection.createStatement().executeUpdate(this.dialect.initializeMapTile());
                    this.executeUpdate(connection, this.dialect.updateStorageMeta(), "3", "schema_version");
                }, 2);
                schemaVersion = 3;
            }
            if (schemaVersion == 1) {
                throw new IOException("Outdated database schema: " + schemaVersion + " (Cannot automatically update, reset your database and reload bluemap to fix this)");
            }
            if (schemaVersion == 2) {
                Logger.global.logInfo("Updating database schema: Renaming bluemap_map_meta keys to new format...");
                this.recoveringConnection((Connection connection) -> {
                    this.executeUpdate(connection, this.dialect.deleteMapMeta(), "settings.json", "textures.json", ".rstate");
                    this.executeUpdate(connection, this.dialect.updateMapMeta(), "settings.json", "settings");
                    this.executeUpdate(connection, this.dialect.updateMapMeta(), "textures.json", "textures");
                    this.executeUpdate(connection, this.dialect.updateMapMeta(), ".rstate", "render_state");
                    this.executeUpdate(connection, this.dialect.updateStorageMeta(), "3", "schema_version");
                }, 2);
                int n = 3;
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.dataSource instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.dataSource)).close();
            }
            catch (Exception ex) {
                throw new IOException("Failed to close datasource!", ex);
            }
        }
    }

    protected ResultSet executeQuery(Connection connection, @Language(value="sql") String sql, Object ... parameters) throws SQLException {
        return this.prepareStatement(connection, sql, parameters).executeQuery();
    }

    protected int executeUpdate(Connection connection, @Language(value="sql") String sql, Object ... parameters) throws SQLException {
        return this.prepareStatement(connection, sql, parameters).executeUpdate();
    }

    private PreparedStatement prepareStatement(Connection connection, @Language(value="sql") String sql, Object ... parameters) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        for (int i = 0; i < parameters.length; ++i) {
            statement.setObject(i + 1, parameters[i]);
        }
        return statement;
    }

    protected void recoveringConnection(ConnectionConsumer action, int tries) throws SQLException, IOException {
        this.recoveringConnection((ConnectionFunction)action, tries);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <R> R recoveringConnection(ConnectionFunction<R> action, int tries) throws SQLException, IOException {
        SQLRecoverableException sqlException = null;
        try {
            for (int i = 0; i < tries; ++i) {
                try (Connection connection = this.dataSource.getConnection();){
                    R result = action.apply(connection);
                    connection.commit();
                    R r = result;
                    return r;
                }
            }
        }
        catch (IOException | RuntimeException | SQLException ex) {
            if (sqlException == null) throw ex;
            ex.addSuppressed(sqlException);
            throw ex;
        }
        if ($assertionsDisabled) throw sqlException;
        if (sqlException != null) throw sqlException;
        throw new AssertionError();
    }

    protected int getMapFK(String mapId) throws SQLException {
        try {
            return Objects.requireNonNull(this.mapFKs.get(mapId));
        }
        catch (CompletionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw ex;
        }
    }

    int getMapTileCompressionFK(Compression compression) throws SQLException {
        try {
            return Objects.requireNonNull(this.mapTileCompressionFKs.get(compression));
        }
        catch (CompletionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadMapFK(String mapId) throws SQLException, IOException {
        LoadingCache<String, Integer> loadingCache = this.mapFKs;
        synchronized (loadingCache) {
            return this.lookupFK("bluemap_map", "id", "map_id", mapId);
        }
    }

    private int loadMapTileCompressionFK(Compression compression) throws SQLException, IOException {
        return this.lookupFK("bluemap_map_tile_compression", "id", "compression", compression.getTypeId());
    }

    private int lookupFK(String table, String idField, String valueField, String value) throws SQLException, IOException {
        return this.recoveringConnection((Connection connection) -> {
            int key;
            ResultSet result = this.executeQuery(connection, this.dialect.lookupFK(table, idField, valueField), value);
            if (result.next()) {
                key = result.getInt("id");
            } else {
                PreparedStatement statement = connection.prepareStatement(this.dialect.insertFK(table, valueField), 1);
                statement.setString(1, value);
                statement.executeUpdate();
                ResultSet keys = statement.getGeneratedKeys();
                if (!keys.next()) {
                    throw new IllegalStateException("No generated key returned!");
                }
                key = keys.getInt(1);
            }
            return key;
        }, 2);
    }

    private DataSource createDataSource(String dbUrl, Map<String, String> properties, int maxPoolSize) {
        Properties props = new Properties();
        props.putAll(properties);
        return this.createDataSource(new DriverManagerConnectionFactory(dbUrl, props), maxPoolSize);
    }

    private DataSource createDataSource(String dbUrl, Map<String, String> properties, int maxPoolSize, Driver driver) {
        Properties props = new Properties();
        props.putAll(properties);
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory(driver, dbUrl, props);
        return this.createDataSource(connectionFactory, maxPoolSize);
    }

    private DataSource createDataSource(ConnectionFactory connectionFactory, int maxPoolSize) {
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(() -> {
            Logger.global.logDebug("Creating new SQL-Connection...");
            return connectionFactory.createConnection();
        }, null);
        poolableConnectionFactory.setPoolStatements(true);
        poolableConnectionFactory.setMaxOpenPreparedStatements(20);
        poolableConnectionFactory.setDefaultAutoCommit(false);
        poolableConnectionFactory.setAutoCommitOnReturn(false);
        poolableConnectionFactory.setRollbackOnReturn(true);
        poolableConnectionFactory.setFastFailValidation(true);
        GenericObjectPoolConfig objectPoolConfig = new GenericObjectPoolConfig();
        objectPoolConfig.setTestWhileIdle(true);
        objectPoolConfig.setTimeBetweenEvictionRuns(Duration.ofSeconds(10L));
        objectPoolConfig.setNumTestsPerEvictionRun(3);
        objectPoolConfig.setBlockWhenExhausted(true);
        objectPoolConfig.setMinIdle(1);
        objectPoolConfig.setMaxIdle(Runtime.getRuntime().availableProcessors());
        objectPoolConfig.setMaxTotal(maxPoolSize);
        objectPoolConfig.setMaxWaitMillis(Duration.ofSeconds(30L).toMillis());
        GenericObjectPool<PoolableConnection> connectionPool = new GenericObjectPool<PoolableConnection>(poolableConnectionFactory, objectPoolConfig);
        poolableConnectionFactory.setPool(connectionPool);
        return new PoolingDataSource<PoolableConnection>(connectionPool);
    }

    public static SQLStorage create(SQLStorageSettings settings) throws Exception {
        String dbUrl = settings.getConnectionUrl();
        String provider = dbUrl.strip().split(":", 3)[1];
        return DialectType.getStorage(provider, settings);
    }

    @FunctionalInterface
    public static interface ConnectionFunction<R> {
        public R apply(Connection var1) throws SQLException, IOException;
    }

    @FunctionalInterface
    public static interface ConnectionConsumer
    extends ConnectionFunction<Void> {
        public void accept(Connection var1) throws SQLException, IOException;

        @Override
        default public Void apply(Connection connection) throws SQLException, IOException {
            this.accept(connection);
            return null;
        }
    }
}

