/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.threejs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.core.threejs.BufferAttribute;
import de.bluecolored.bluemap.core.threejs.MaterialGroup;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class BufferGeometry {
    public Map<String, BufferAttribute> attributes;
    public MaterialGroup[] groups;

    private BufferGeometry() {
    }

    public BufferGeometry(float[] position, float[] normal, float[] color, float[] uv, MaterialGroup[] groups) {
        this.attributes = new HashMap<String, BufferAttribute>();
        this.addAttribute("position", new BufferAttribute(position, 3));
        this.addAttribute("normal", new BufferAttribute(normal, 3));
        this.addAttribute("color", new BufferAttribute(color, 3));
        this.addAttribute("uv", new BufferAttribute(uv, 2));
        this.groups = groups;
    }

    public void addAttribute(String name, BufferAttribute attribute) {
        this.attributes.put(name, attribute);
    }

    public boolean isValid() {
        int faceCount = this.getFaceCount();
        for (BufferAttribute attribute : this.attributes.values()) {
            if (attribute.getItemCount() == faceCount) continue;
            return false;
        }
        return true;
    }

    public int getFaceCount() {
        if (this.attributes.isEmpty()) {
            return 0;
        }
        BufferAttribute attribute = this.attributes.values().iterator().next();
        return attribute.getItemCount();
    }

    public String toJson() {
        try {
            StringWriter sw = new StringWriter();
            Gson gson = new GsonBuilder().create();
            JsonWriter json = gson.newJsonWriter((Writer)sw);
            json.beginObject();
            json.name("tileGeometry").beginObject();
            json.name("type").value("BufferGeometry");
            json.name("uuid").value(UUID.randomUUID().toString().toUpperCase());
            json.name("data").beginObject();
            json.name("attributes").beginObject();
            for (Map.Entry<String, BufferAttribute> entry : this.attributes.entrySet()) {
                json.name(entry.getKey());
                entry.getValue().writeJson(json);
            }
            json.endObject();
            json.name("groups").beginArray();
            for (MaterialGroup g2 : this.groups) {
                json.beginObject();
                json.name("materialIndex").value((long)g2.getMaterialIndex());
                json.name("start").value((long)g2.getStart());
                json.name("count").value((long)g2.getCount());
                json.endObject();
            }
            json.endArray();
            json.endObject();
            json.endObject();
            json.endObject();
            json.flush();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferGeometry fromJson(String jsonString) throws IOException {
        Gson gson = new GsonBuilder().create();
        JsonReader json = gson.newJsonReader((Reader)new StringReader(jsonString));
        ArrayList<MaterialGroup> groups = new ArrayList<MaterialGroup>(10);
        HashMap<String, BufferAttribute> attributes = new HashMap<String, BufferAttribute>();
        json.beginObject();
        while (!"tileGeometry".equals(json.nextName())) {
            json.skipValue();
        }
        json.beginObject();
        while (json.hasNext()) {
            String name1 = json.nextName();
            if (name1.equals("data")) {
                json.beginObject();
                while (json.hasNext()) {
                    String name2 = json.nextName();
                    if (name2.equals("attributes")) {
                        json.beginObject();
                        while (json.hasNext()) {
                            String name3 = json.nextName();
                            attributes.put(name3, BufferAttribute.readJson(json));
                        }
                        json.endObject();
                        continue;
                    }
                    if (name2.equals("groups")) {
                        json.beginArray();
                        while (json.hasNext()) {
                            MaterialGroup group = new MaterialGroup(0, 0, 0);
                            json.beginObject();
                            while (json.hasNext()) {
                                String name3 = json.nextName();
                                if (name3.equals("materialIndex")) {
                                    group.setMaterialIndex(json.nextInt());
                                    continue;
                                }
                                if (name3.equals("start")) {
                                    group.setStart(json.nextInt());
                                    continue;
                                }
                                if (name3.equals("count")) {
                                    group.setCount(json.nextInt());
                                    continue;
                                }
                                json.skipValue();
                            }
                            json.endObject();
                            groups.add(group);
                        }
                        json.endArray();
                        continue;
                    }
                    json.skipValue();
                }
                json.endObject();
                continue;
            }
            json.skipValue();
        }
        json.endObject();
        while (json.hasNext()) {
            json.skipValue();
        }
        json.endObject();
        groups.sort((g1, g2) -> (int)Math.signum(g1.getStart() - g2.getStart()));
        int nextGroup = 0;
        for (MaterialGroup g3 : groups) {
            if (g3.getStart() != nextGroup) {
                throw new IllegalArgumentException("Group did not start at correct index! (Got " + g3.getStart() + " but expected " + nextGroup + ")");
            }
            if (g3.getCount() < 0) {
                throw new IllegalArgumentException("Group has a negative count! (" + g3.getCount() + ")");
            }
            nextGroup += g3.getCount();
        }
        BufferGeometry bufferGeometry = new BufferGeometry();
        bufferGeometry.attributes = attributes;
        bufferGeometry.groups = groups.toArray(new MaterialGroup[groups.size()]);
        return bufferGeometry;
    }
}

