/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import de.bluecolored.bluemap.core.util.WrappedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class FileHelper {
    public static OutputStream createFilepartOutputStream(Path file) throws IOException {
        Path partFile = FileHelper.getPartFile(file);
        FileHelper.createDirectories(partFile.getParent(), new FileAttribute[0]);
        OutputStream os = Files.newOutputStream(partFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        return new WrappedOutputStream(os, () -> {
            if (!Files.exists(partFile, new LinkOption[0])) {
                return;
            }
            FileHelper.createDirectories(file.getParent(), new FileAttribute[0]);
            FileHelper.move(partFile, file);
        });
    }

    public static void move(Path from, Path to) throws IOException {
        try {
            Files.move(from, to, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException ex) {
            try {
                Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
            }
            catch (Throwable t) {
                t.addSuppressed(ex);
                throw t;
            }
        }
    }

    public static Path createDirectories(Path dir, FileAttribute<?> ... attrs) throws IOException {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            return dir;
        }
        return Files.createDirectories(dir, attrs);
    }

    private static Path getPartFile(Path file) {
        return file.normalize().getParent().resolve(file.getFileName() + ".filepart");
    }
}

