/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Supplier;

public class InstancePool<T> {
    private final Supplier<T> creator;
    private final Function<T, T> recycler;
    private final ConcurrentLinkedQueue<T> pool = new ConcurrentLinkedQueue();

    public InstancePool(Supplier<T> creator) {
        this.creator = creator;
        this.recycler = t -> t;
    }

    public InstancePool(Supplier<T> creator, Function<T, T> recycler) {
        this.creator = creator;
        this.recycler = recycler;
    }

    public T claimInstance() {
        T instance = this.pool.poll();
        if (instance == null) {
            instance = this.creator.get();
        }
        return instance;
    }

    public void recycleInstance(T instance) {
        if ((instance = this.recycler.apply(instance)) != null) {
            this.pool.offer(instance);
        }
    }
}

