/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import java.io.IOException;
import java.io.OutputStream;

public class WrappedOutputStream
extends OutputStream {
    private final OutputStream out;
    private final AutoCloseable onClose;

    public WrappedOutputStream(OutputStream out, AutoCloseable onClose) {
        this.out = out;
        this.onClose = onClose;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        IOException ioExcetion = null;
        try {
            this.out.close();
        }
        catch (IOException ex) {
            ioExcetion = ex;
        }
        try {
            this.onClose.close();
        }
        catch (Exception ex) {
            if (ioExcetion == null) {
                ioExcetion = ex instanceof IOException ? (IOException)ex : new IOException(ex);
            }
            ioExcetion.addSuppressed(ex);
        }
        if (ioExcetion != null) {
            throw ioExcetion;
        }
    }
}

