/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util.math;

import com.flowpowered.math.TrigMath;
import de.bluecolored.bluemap.core.util.math.MatrixM3f;

public class VectorM2f {
    public float x;
    public float y;

    public VectorM2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public VectorM2f set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public VectorM2f translate(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public VectorM2f rotate(float sx, float sy) {
        return this.set(this.x * sx - this.y * sy, this.y * sx + this.x * sy);
    }

    public VectorM2f transform(MatrixM3f t) {
        return this.set(t.m00 * this.x + t.m01 * this.y + t.m02, t.m10 * this.x + t.m11 * this.y + t.m12);
    }

    public VectorM2f normalize() {
        float length = this.length();
        this.x /= length;
        this.y /= length;
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float angleTo(float x, float y) {
        return (float)TrigMath.acos((double)(this.x * x + this.y * y) / ((double)this.length() * Math.sqrt(x * x + y * y)));
    }
}

