/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.math.Color;

@DebugDump
public class Biome
extends Key {
    public static final Biome DEFAULT = new Biome("minecraft:ocean");
    private float humidity = 0.5f;
    private float temp = 0.5f;
    private final Color waterColor = new Color().set(-12618012).premultiplied();
    private final Color overlayFoliageColor = new Color().premultiplied();
    private final Color overlayGrassColor = new Color().premultiplied();

    public Biome(String formatted) {
        super(formatted);
    }

    public Biome(String formatted, float humidity, float temp, Color waterColor) {
        this(formatted);
        this.humidity = humidity;
        this.temp = temp;
        this.waterColor.set(waterColor).premultiplied();
    }

    public Biome(String formatted, float humidity, float temp, Color waterColor, Color overlayFoliageColor, Color overlayGrassColor) {
        this(formatted, humidity, temp, waterColor);
        this.overlayFoliageColor.set(overlayFoliageColor).premultiplied();
        this.overlayGrassColor.set(overlayGrassColor).premultiplied();
    }

    public float getHumidity() {
        return this.humidity;
    }

    public float getTemp() {
        return this.temp;
    }

    public Color getWaterColor() {
        return this.waterColor;
    }

    public Color getOverlayFoliageColor() {
        return this.overlayFoliageColor;
    }

    public Color getOverlayGrassColor() {
        return this.overlayGrassColor;
    }

    @Override
    public String toString() {
        return "Biome{value='" + this.getValue() + "', namespace=" + this.getNamespace() + ", formatted=" + this.getFormatted() + ", humidity=" + this.humidity + ", temp=" + this.temp + ", waterColor=" + this.waterColor + ", overlayFoliageColor=" + this.overlayFoliageColor + ", overlayGrassColor=" + this.overlayGrassColor + "}";
    }
}

