/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.World;

public class Block<T extends Block<T>> {
    private World world;
    private int x;
    private int y;
    private int z;
    private Chunk chunk;
    private BlockState blockState;
    private final LightData lightData = new LightData(-1, -1);
    private String biomeId;

    public Block(World world, int x, int y, int z) {
        this.set(world, x, y, z);
    }

    public T set(World world, int x, int y, int z) {
        if (this.x == x && this.z == z && this.world == world) {
            if (this.y == y) {
                return this.self();
            }
        } else {
            this.chunk = null;
        }
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.reset();
        return this.self();
    }

    public T set(int x, int y, int z) {
        if (this.x == x && this.z == z) {
            if (this.y == y) {
                return this.self();
            }
        } else {
            this.chunk = null;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.reset();
        return this.self();
    }

    protected void reset() {
        this.blockState = null;
        this.lightData.set(-1, -1);
        this.biomeId = null;
    }

    public T add(int dx, int dy, int dz) {
        return this.set(this.x + dx, this.y + dy, this.z + dz);
    }

    public T copy(Block<?> source) {
        this.world = source.world;
        this.chunk = source.chunk;
        this.x = source.x;
        this.y = source.y;
        this.z = source.z;
        this.reset();
        this.blockState = source.blockState;
        this.lightData.set(source.lightData.getSkyLight(), source.lightData.getBlockLight());
        this.biomeId = source.biomeId;
        return this.self();
    }

    public T copy(Block<?> source, int dx, int dy, int dz) {
        this.world = source.world;
        this.x = source.x + dx;
        this.y = source.y + dy;
        this.z = source.z + dz;
        this.chunk = null;
        this.reset();
        return this.self();
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Chunk getChunk() {
        if (this.chunk == null) {
            this.chunk = this.world.getChunkAtBlock(this.x, this.y, this.z);
        }
        return this.chunk;
    }

    public BlockState getBlockState() {
        if (this.blockState == null) {
            this.blockState = this.getChunk().getBlockState(this.x, this.y, this.z);
        }
        return this.blockState;
    }

    public LightData getLightData() {
        if (this.lightData.getSkyLight() < 0) {
            this.getChunk().getLightData(this.x, this.y, this.z, this.lightData);
        }
        return this.lightData;
    }

    public String getBiomeId() {
        if (this.biomeId == null) {
            this.biomeId = this.getChunk().getBiome(this.x, this.y, this.z);
        }
        return this.biomeId;
    }

    public int getSunLightLevel() {
        return this.getLightData().getSkyLight();
    }

    public int getBlockLightLevel() {
        return this.getLightData().getBlockLight();
    }

    public String toString() {
        if (this.world != null) {
            return "Block{world=" + this.world + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", chunk=" + this.getChunk() + ", blockState=" + this.getBlockState() + ", lightData=" + this.getLightData() + ", biomeId=" + this.getBiomeId() + "}";
        }
        return "Block{world=null, x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }

    protected T self() {
        return (T)this;
    }
}

