/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.forge;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.plugin.text.Text;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.forge.ForgeMod;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.Vec3;

public class ForgeCommandSource
implements CommandSource {
    private final ForgeMod mod;
    private final Plugin plugin;
    private final CommandSourceStack delegate;

    public ForgeCommandSource(ForgeMod mod, Plugin plugin, CommandSourceStack delegate) {
        this.mod = mod;
        this.plugin = plugin;
        this.delegate = delegate;
    }

    @Override
    public void sendMessage(Text text) {
        MutableComponent component = Component.Serializer.fromJsonLenient((String)text.toJSONString());
        if (component != null) {
            this.delegate.sendSuccess(() -> component, false);
        }
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.delegate.hasPermission(1);
    }

    @Override
    public Optional<Vector3d> getPosition() {
        Vec3 pos = this.delegate.getPosition();
        return Optional.of(new Vector3d(pos.x, pos.y, pos.z));
    }

    @Override
    public Optional<World> getWorld() {
        try {
            ServerWorld serverWorld = this.mod.getWorld(this.delegate.getLevel());
            String worldId = this.plugin.getBlueMap().getWorldId(serverWorld.getSaveFolder());
            return Optional.ofNullable(this.plugin.getWorlds().get(worldId));
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
    }
}

