/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.forge;

import de.bluecolored.bluemap.common.serverinterface.Dimension;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;

public class ForgeWorld
implements ServerWorld {
    private final WeakReference<ServerLevel> delegate;
    private final Path saveFolder;

    public ForgeWorld(ServerLevel delegate) {
        this.delegate = new WeakReference<ServerLevel>(delegate);
        MinecraftServer server = delegate.getServer();
        Path worldFolder = delegate.getServer().getServerDirectory().toPath().resolve(server.getWorldPath(LevelResource.ROOT));
        this.saveFolder = DimensionType.getStorageFolder((ResourceKey)delegate.dimension(), (Path)worldFolder).toAbsolutePath().normalize();
    }

    @Override
    public Dimension getDimension() {
        ServerLevel world = (ServerLevel)this.delegate.get();
        if (world != null) {
            if (world.dimension().equals(Level.NETHER)) {
                return Dimension.NETHER;
            }
            if (world.dimension().equals(Level.END)) {
                return Dimension.END;
            }
            if (world.dimension().equals(Level.OVERWORLD)) {
                return Dimension.OVERWORLD;
            }
        }
        return ServerWorld.super.getDimension();
    }

    @Override
    public boolean persistWorldChanges() throws IOException {
        ServerLevel world = (ServerLevel)this.delegate.get();
        if (world == null) {
            return false;
        }
        CompletableFuture<Boolean> taskResult = CompletableFuture.supplyAsync(() -> {
            try {
                world.save(null, true, false);
                return true;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)world.getServer());
        try {
            return taskResult.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            throw new IOException(t);
        }
    }

    @Override
    public Path getSaveFolder() {
        return this.saveFolder;
    }
}

