/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.benmanes.caffeine.cache.stats;

import de.bluecolored.shadow.benmanes.caffeine.cache.RemovalCause;
import de.bluecolored.shadow.benmanes.caffeine.cache.stats.CacheStats;
import de.bluecolored.shadow.benmanes.caffeine.cache.stats.DisabledStatsCounter;
import de.bluecolored.shadow.benmanes.caffeine.cache.stats.GuardedStatsCounter;
import de.bluecolored.shadow.checkerframework.checker.index.qual.NonNegative;
import de.bluecolored.shadow.checkerframework.checker.nullness.qual.NonNull;

public interface StatsCounter {
    public void recordHits(@NonNegative int var1);

    public void recordMisses(@NonNegative int var1);

    public void recordLoadSuccess(@NonNegative long var1);

    public void recordLoadFailure(@NonNegative long var1);

    @Deprecated
    public void recordEviction();

    @Deprecated
    default public void recordEviction(@NonNegative int weight) {
        this.recordEviction();
    }

    default public void recordEviction(@NonNegative int weight, RemovalCause cause) {
        this.recordEviction(weight);
    }

    public @NonNull CacheStats snapshot();

    public static @NonNull StatsCounter disabledStatsCounter() {
        return DisabledStatsCounter.INSTANCE;
    }

    public static @NonNull StatsCounter guardedStatsCounter(@NonNull StatsCounter statsCounter) {
        return statsCounter instanceof GuardedStatsCounter ? statsCounter : new GuardedStatsCounter(statsCounter);
    }
}

