/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt;

import de.bluecolored.shadow.querz.nbt.NumberTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ByteTag
extends NumberTag<Byte>
implements Comparable<ByteTag> {
    public static final byte ZERO_VALUE = 0;

    public ByteTag() {
        super((byte)0);
    }

    public ByteTag(byte value) {
        super(value);
    }

    public ByteTag(boolean value) {
        super((byte)(value ? 1 : 0));
    }

    public boolean asBoolean() {
        return (Byte)this.getValue() > 0;
    }

    @Override
    public void setValue(byte value) {
        super.setValue(value);
    }

    @Override
    public void serializeValue(DataOutputStream dos, int maxDepth) throws IOException {
        dos.writeByte(((Byte)this.getValue()).byteValue());
    }

    @Override
    public void deserializeValue(DataInputStream dis, int maxDepth) throws IOException {
        this.setValue(dis.readByte());
    }

    @Override
    public String valueToTagString(int maxDepth) {
        return this.getValue() + "b";
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.asByte() == ((ByteTag)other).asByte();
    }

    @Override
    public int compareTo(ByteTag other) {
        return ((Byte)this.getValue()).compareTo((Byte)other.getValue());
    }

    @Override
    public ByteTag clone() {
        return new ByteTag((Byte)this.getValue());
    }
}

