/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt.custom;

import de.bluecolored.shadow.querz.nbt.Tag;
import de.bluecolored.shadow.querz.nbt.TagFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CharTag
extends Tag<Character>
implements Comparable<CharTag> {
    public static final char ZERO_VALUE = '\u0000';

    public static void register() {
        TagFactory.registerCustomTag(110, CharTag::new, CharTag.class);
    }

    public CharTag() {
        super(Character.valueOf('\u0000'));
    }

    public CharTag(char value) {
        super(Character.valueOf(value));
    }

    @Override
    public Character getValue() {
        return (Character)super.getValue();
    }

    @Override
    public void setValue(char value) {
        super.setValue(Character.valueOf(value));
    }

    @Override
    public void serializeValue(DataOutputStream dos, int maxDepth) throws IOException {
        dos.writeChar(this.getValue().charValue());
    }

    @Override
    public void deserializeValue(DataInputStream dis, int maxDepth) throws IOException {
        this.setValue(dis.readChar());
    }

    @Override
    public String valueToString(int maxDepth) {
        return CharTag.escapeString(this.getValue() + "", false);
    }

    @Override
    public String valueToTagString(int maxDepth) {
        return CharTag.escapeString(this.getValue() + "", true);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.getValue() == ((CharTag)other).getValue();
    }

    @Override
    public int compareTo(CharTag o) {
        return Character.compare(this.getValue().charValue(), o.getValue().charValue());
    }

    @Override
    public CharTag clone() {
        return new CharTag(this.getValue().charValue());
    }
}

