/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.raytrace;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.util.GameSupport;
import me.cg360.mod.bridging.util.Path;
import me.cg360.mod.bridging.util.PlacementAxisMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PathTraversalHandler {
    private static final float MIN_DISTANCE = 1.0f;
    private static final double DIRECTION_SIMILARITY_THRESHOLD = 0.1;

    public static Tuple<BlockPos, Direction> getClosestAssistTarget(Player player) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        List<BlockPos> path = PathTraversalHandler.getViewBlockPath(player);
        Vec3 viewDirection = player.getViewVector(1.0f);
        List<Direction> validSides = PathTraversalHandler.getValidAssistSides(viewDirection);
        Direction validDirection = null;
        BlockPos validPos = null;
        for (BlockPos pos : path) {
            Optional<Direction> firstValidDirection;
            if (!PathTraversalHandler.isBridgingPlacementAllowedAt(pos)) continue;
            Vec3 collideMin = Vec3.atLowerCornerOf((Vec3i)pos);
            Vec3 collideMax = Vec3.atLowerCornerWithOffset((Vec3i)pos, (double)1.0, (double)1.0, (double)1.0);
            if (player.getBoundingBox().intersects(collideMin, collideMax) || (firstValidDirection = validSides.stream().filter(dir -> PathTraversalHandler.canSideBeBuiltOffOf(pos, dir)).findFirst()).isEmpty()) continue;
            validDirection = firstValidDirection.get();
            validPos = pos;
            break;
        }
        if (validDirection == null || validPos == null) {
            return null;
        }
        return new Tuple(validPos, validDirection);
    }

    public static List<BlockPos> getViewBlockPath(Player player) {
        if (player == null) {
            return new ArrayList<BlockPos>();
        }
        float eyeOffset = player.getEyeHeight(player.getPose());
        Vec3 viewOrigin = player.position().add(0.0, (double)eyeOffset, 0.0);
        Vec3 viewDirection = player.getViewVector(1.0f);
        Vec3 nearVec = viewDirection.scale(1.0);
        Vec3 farVec = viewDirection.scale(GameSupport.getReach());
        BlockPos startPos = BlockPos.containing((Position)viewOrigin.add(nearVec));
        BlockPos endPos = BlockPos.containing((Position)viewOrigin.add(farVec));
        return Path.calculateBresenhamVoxels(startPos, endPos);
    }

    private static List<Direction> getValidAssistSides(Vec3 viewDirection) {
        LinkedList<Direction> validSides = new LinkedList<Direction>();
        for (Direction direction : Direction.values()) {
            Vec3 directionNormal = Vec3.atLowerCornerOf((Vec3i)direction.getNormal());
            double similarity = viewDirection.dot(directionNormal);
            if (similarity < 0.1) continue;
            validSides.add(direction.getOpposite());
        }
        return validSides;
    }

    private static boolean canSideBeBuiltOffOf(BlockPos placementTarget, Direction checkSide) {
        PlacementAxisMode mode;
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return false;
        }
        PlacementAxisMode baseMode = BridgingMod.getConfig().getSupportedBridgeAxes();
        if (GameSupport.isControllerCrouching() ? !(mode = BridgingMod.getConfig().getSupportedBridgeAxesWhenCrouched().getPlacementAxisMode(baseMode)).isDirectionEnabled(checkSide) : !baseMode.isDirectionEnabled(checkSide)) {
            return false;
        }
        BlockPos blockPlacingOffOf = placementTarget.offset(checkSide.getNormal());
        if (level.isEmptyBlock(blockPlacingOffOf)) {
            return false;
        }
        if (level.getBlockState(blockPlacingOffOf).getBlock() instanceof LiquidBlock) {
            return false;
        }
        return !level.getBlockState(blockPlacingOffOf).canBeReplaced();
    }

    private static boolean isBridgingPlacementAllowedAt(BlockPos placementTarget) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return false;
        }
        BlockState target = level.getBlockState(placementTarget);
        return BridgingMod.getConfig().isNonSolidReplaceEnabled() ? target.canBeReplaced() : target.isAir();
    }
}

