/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.EmptyAlmostUnifiedRuntime;
import com.almostreliable.unified.ItemHider;
import com.almostreliable.unified.LoggerFactory;
import com.almostreliable.unified.PluginManager;
import com.almostreliable.unified.api.Placeholders;
import com.almostreliable.unified.api.TagMap;
import com.almostreliable.unified.api.UnifyHandler;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.DebugConfig;
import com.almostreliable.unified.config.DuplicationConfig;
import com.almostreliable.unified.config.PlaceholdersConfig;
import com.almostreliable.unified.config.StartupConfig;
import com.almostreliable.unified.config.TagConfig;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.impl.AlmostUnifiedRuntimeImpl;
import com.almostreliable.unified.impl.TagMapImpl;
import com.almostreliable.unified.impl.TagOwnershipsImpl;
import com.almostreliable.unified.impl.UnifyHandlerImpl;
import com.almostreliable.unified.recipe.unifier.UnifierRegistryImpl;
import com.almostreliable.unified.utils.FileUtils;
import com.almostreliable.unified.utils.TagReloadHandler;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public final class AlmostUnified {
    private static final LoggerFactory.Policy LOGGER_POLICY = new LoggerFactory.Policy();
    public static final Logger LOG = LoggerFactory.createCustomLogger(LOGGER_POLICY);
    @Nullable
    private static AlmostUnifiedRuntime RUNTIME;
    @Nullable
    private static StartupConfig STARTUP_CONFIG;

    public static boolean isRuntimeLoaded() {
        return RUNTIME != null;
    }

    public static AlmostUnifiedRuntime getRuntime() {
        if (RUNTIME == null) {
            return new EmptyAlmostUnifiedRuntime();
        }
        return RUNTIME;
    }

    public static StartupConfig getStartupConfig() {
        if (STARTUP_CONFIG == null) {
            STARTUP_CONFIG = Config.load("startup", new StartupConfig.Serializer());
        }
        return STARTUP_CONFIG;
    }

    public static void onTagLoaderReload(Map<ResourceLocation, Collection<Holder<Item>>> tags) {
        LOGGER_POLICY.reset();
        UnifierRegistryImpl unifierRegistry = new UnifierRegistryImpl();
        PluginManager.instance().registerUnifiers(unifierRegistry);
        FileUtils.createGitIgnoreIfNotExists();
        TagConfig tagConfig = Config.load("tags", new TagConfig.Serializer());
        PlaceholdersConfig replacementsConfig = Config.load("placeholders", new PlaceholdersConfig.Serializer());
        DuplicationConfig dupConfig = Config.load("duplicates", new DuplicationConfig.Serializer());
        DebugConfig debugConfig = Config.load("debug", new DebugConfig.Serializer());
        Collection<UnifyConfig> unifyConfigs = UnifyConfig.safeLoadConfigs();
        Set<TagKey<Item>> allUnifyTags = AlmostUnified.bakeAndValidateTags(unifyConfigs, tags, replacementsConfig);
        TagReloadHandler.applyCustomTags(tagConfig.getCustomTags());
        TagOwnershipsImpl tagOwnerships = new TagOwnershipsImpl(allUnifyTags::contains, tagConfig.getTagOwnerships());
        tagOwnerships.applyOwnerships(tags);
        List<UnifyHandler> unifyHandlers = AlmostUnified.createAndPrepareUnifyHandlers(tags, unifyConfigs, tagOwnerships, tagConfig);
        TagMap<Item> tagMap = TagMapImpl.compose(unifyHandlers.stream().map(UnifyHandler::getTagMap).toList());
        ItemHider.applyHideTags(tags, unifyHandlers);
        RUNTIME = new AlmostUnifiedRuntimeImpl(tagMap, unifyHandlers, dupConfig, debugConfig, unifierRegistry, tagOwnerships);
    }

    private static List<UnifyHandler> createAndPrepareUnifyHandlers(Map<ResourceLocation, Collection<Holder<Item>>> tags, Collection<UnifyConfig> unifyConfigs, TagOwnershipsImpl tagOwnerships, TagConfig tagConfig) {
        TagMap<Item> globalTagMap = TagMapImpl.createFromItemTags(tags);
        List<UnifyHandler> unifyHandlers = UnifyHandlerImpl.create(unifyConfigs, globalTagMap, tagOwnerships);
        boolean needsRebuild = TagReloadHandler.applyInheritance(tagConfig.getItemTagInheritance(), tagConfig.getBlockTagInheritance(), globalTagMap, unifyHandlers);
        if (needsRebuild) {
            unifyHandlers = UnifyHandlerImpl.create(unifyConfigs, TagMapImpl.createFromItemTags(tags), tagOwnerships);
        }
        return unifyHandlers;
    }

    private static Set<TagKey<Item>> bakeAndValidateTags(Collection<UnifyConfig> unifyConfigs, Map<ResourceLocation, Collection<Holder<Item>>> vanillaTags, Placeholders placeholders) {
        HashSet<TagKey<Item>> result = new HashSet<TagKey<Item>>();
        HashMap visitedTags = new HashMap();
        HashSet wrongTags = new HashSet();
        for (UnifyConfig config : unifyConfigs) {
            Predicate<TagKey<Item>> validator = tag -> {
                if (!vanillaTags.containsKey(tag.location())) {
                    wrongTags.add(tag);
                    return false;
                }
                if (visitedTags.containsKey(tag)) {
                    LOG.warn("Tag '{}' from unify config '{}' was already created in unify config '{}'", (Object)config.getName(), (Object)tag.location(), visitedTags.get(tag));
                    return false;
                }
                visitedTags.put(tag, config.getName());
                return true;
            };
            Set<TagKey<Item>> tags = config.bakeTags(validator, placeholders);
            result.addAll(tags);
        }
        if (!wrongTags.isEmpty()) {
            LOG.warn("The following tags are invalid or not in use and will be ignored: {}", wrongTags.stream().map(TagKey::location).collect(Collectors.toList()));
        }
        return result;
    }

    public static void onRecipeManagerReload(Map<ResourceLocation, JsonElement> recipes) {
        Preconditions.checkNotNull((Object)RUNTIME, (Object)"AlmostUnifiedRuntime was not loaded correctly");
        RUNTIME.run(recipes, AlmostUnified.getStartupConfig().isServerOnly());
    }

    private static Layout<? extends Serializable> getLayout(@Nullable Appender appender, Configuration config) {
        if (appender == null) {
            return PatternLayout.newBuilder().withConfiguration(config).withPattern("%d{yyyy-MM-dd HH:mm:ss} %-5p %c{1}:%L - %msg%n").build();
        }
        return appender.getLayout();
    }
}

