/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.PluginManager;
import com.almostreliable.unified.api.plugin.AlmostUnifiedNeoPlugin;
import com.almostreliable.unified.api.plugin.AlmostUnifiedPlugin;
import com.almostreliable.unified.recipe.ClientRecipeTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

@Mod(value="almostunified")
public class AlmostUnifiedForge {
    public AlmostUnifiedForge(IEventBus eventBus) {
        if (!AlmostUnified.getStartupConfig().isServerOnly()) {
            eventBus.addListener(this::onRegisterClientSyncRecipe);
        }
        eventBus.addListener(this::onCommonSetup);
    }

    private void onRegisterClientSyncRecipe(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.RECIPE_SERIALIZER)) {
            Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)ClientRecipeTracker.ID, ClientRecipeTracker.SERIALIZER);
        }
        if (event.getRegistryKey().equals(Registries.RECIPE_TYPE)) {
            Registry.register((Registry)BuiltInRegistries.RECIPE_TYPE, (ResourceLocation)ClientRecipeTracker.ID, ClientRecipeTracker.TYPE);
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> PluginManager.initialize(this.getPlugins()));
    }

    private Collection<AlmostUnifiedPlugin> getPlugins() {
        Collection<Class<AlmostUnifiedPlugin>> pluginClasses = this.getPluginClasses();
        ArrayList<AlmostUnifiedPlugin> plugins = new ArrayList<AlmostUnifiedPlugin>();
        try {
            for (Class<AlmostUnifiedPlugin> pluginClass : pluginClasses) {
                plugins.add(pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            AlmostUnified.LOG.error("Failed to create plugin, while loading it: ", (Throwable)e);
        }
        return plugins;
    }

    private Collection<Class<AlmostUnifiedPlugin>> getPluginClasses() {
        HashSet<Class<AlmostUnifiedPlugin>> pluginClasses = new HashSet<Class<AlmostUnifiedPlugin>>();
        Type type = Type.getType(AlmostUnifiedNeoPlugin.class);
        for (ModFileScanData data : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annotation : data.getAnnotations()) {
                Class<AlmostUnifiedPlugin> plugin;
                if (!annotation.annotationType().equals((Object)type) || (plugin = this.getPluginClass(annotation.clazz().getClassName())) == null) continue;
                pluginClasses.add(plugin);
            }
        }
        return pluginClasses;
    }

    @Nullable
    private Class<AlmostUnifiedPlugin> getPluginClass(String className) {
        try {
            Class<AlmostUnifiedPlugin> pluginClass = Class.forName(className);
            if (AlmostUnifiedPlugin.class.isAssignableFrom(pluginClass)) {
                return pluginClass;
            }
            AlmostUnified.LOG.error("Failed to load AlmostUnified plugin: " + className + " does not implement " + AlmostUnifiedPlugin.class.getName());
        }
        catch (ClassNotFoundException e) {
            AlmostUnified.LOG.error("Failed to load AlmostUnified plugin: " + className, (Throwable)e);
            return null;
        }
        return null;
    }
}

