/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.api.UnifierRegistry;
import com.almostreliable.unified.compat.ArsNouveauRecipeUnifier;
import com.almostreliable.unified.compat.CyclicRecipeUnifier;
import com.almostreliable.unified.compat.EnderIORecipeUnifier;
import com.almostreliable.unified.compat.ImmersiveEngineeringRecipeUnifier;
import com.almostreliable.unified.compat.IntegratedDynamicsRecipeUnifier;
import com.almostreliable.unified.compat.MekanismRecipeUnifier;
import com.google.auto.service.AutoService;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;

@AutoService(value={AlmostUnifiedPlatform.class})
public class AlmostUnifiedPlatformNeoForge
implements AlmostUnifiedPlatform {
    @Override
    public AlmostUnifiedPlatform.Platform getPlatform() {
        return AlmostUnifiedPlatform.Platform.FORGE;
    }

    @Override
    public boolean isModLoaded(String modId) {
        if (ModList.get() == null) {
            return LoadingModList.get().getMods().stream().map(ModInfo::getModId).anyMatch(modId::equals);
        }
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isClient() {
        return FMLLoader.getDist() == Dist.CLIENT;
    }

    @Override
    public Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get().resolve("almostunified");
    }

    @Override
    public Path getLogPath() {
        return FMLPaths.GAMEDIR.get().resolve("logs").resolve("almostunified");
    }

    @Override
    public void bindRecipeHandlers(UnifierRegistry factory) {
        List.of("ars_creo", "ars_elemental", "ars_nouveau", "ars_scalaes").forEach(modId -> factory.registerForMod((String)modId, new ArsNouveauRecipeUnifier()));
        factory.registerForMod("cyclic", new CyclicRecipeUnifier());
        factory.registerForMod("enderio", new EnderIORecipeUnifier());
        factory.registerForMod("immersiveengineering", new ImmersiveEngineeringRecipeUnifier());
        factory.registerForMod("integrateddynamics", new IntegratedDynamicsRecipeUnifier());
        factory.registerForMod("mekanism", new MekanismRecipeUnifier());
    }

    @Override
    public Set<TagKey<Item>> getStoneStrataTags(Collection<String> stoneStrataIds) {
        return stoneStrataIds.stream().map(id -> new ResourceLocation("forge", "ores_in_ground/" + id)).map(id -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id)).collect(Collectors.toSet());
    }
}

