/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.api.UnifyHandler;
import com.almostreliable.unified.api.UnifyLookup;
import com.almostreliable.unified.utils.Utils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class ItemHider {
    public static final TagKey<Item> HIDE_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation("almostunified", "hide"));

    public static void applyHideTags(Map<ResourceLocation, Collection<Holder<Item>>> tags, Collection<UnifyHandler> handlers) {
        for (UnifyHandler handler : handlers) {
            if (!handler.hideNonPreferredItemsInRecipeViewers()) continue;
            ItemHider.applyHideTags(tags, handler);
        }
    }

    public static void applyHideTags(Map<ResourceLocation, Collection<Holder<Item>>> tags, UnifyHandler handler) {
        Set<Item> hidingItems = ItemHider.createHidingItems(handler);
        HashSet<Object> itemsToHide = new HashSet<Object>(hidingItems.size());
        for (Item hidingItem : hidingItems) {
            itemsToHide.add(BuiltInRegistries.ITEM.wrapAsHolder((Object)hidingItem));
        }
        Collection<Holder<Item>> existing = tags.get(HIDE_TAG.location());
        if (existing != null) {
            itemsToHide.addAll(existing);
        }
        tags.put(HIDE_TAG.location(), itemsToHide);
    }

    public static Set<Item> createHidingItems(UnifyHandler handler) {
        HashSet<ResourceLocation> hidings = new HashSet<ResourceLocation>();
        for (TagKey<Item> tag : handler.getTagMap().getTags()) {
            Set<ResourceLocation> itemsByTag = handler.getTagMap().getEntriesByTag(tag);
            if (Utils.allSameNamespace(itemsByTag)) continue;
            HashSet<ResourceLocation> replacements = new HashSet<ResourceLocation>();
            for (ResourceLocation item : itemsByTag) {
                replacements.add(ItemHider.getReplacementForItem(handler, item));
            }
            HashSet<ResourceLocation> toHide = new HashSet<ResourceLocation>();
            for (ResourceLocation item : itemsByTag) {
                if (replacements.contains(item)) continue;
                toHide.add(item);
            }
            if (toHide.isEmpty()) continue;
            AlmostUnified.LOG.info("[AutoHiding] Hiding {}/{} items for tag '#{}' -> {}", (Object)toHide.size(), (Object)itemsByTag.size(), (Object)tag.location(), toHide);
            hidings.addAll(toHide);
        }
        return ItemHider.idsToItems(hidings);
    }

    private static Set<Item> idsToItems(Set<ResourceLocation> ids) {
        return ids.stream().flatMap(id -> BuiltInRegistries.ITEM.getOptional(id).stream()).collect(Collectors.toSet());
    }

    private static ResourceLocation getReplacementForItem(UnifyLookup repMap, ResourceLocation item) {
        ResourceLocation replacement = repMap.getReplacementForItem(item);
        if (replacement == null) {
            return item;
        }
        return replacement;
    }
}

