/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.api.UnifyHandler;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class AlmostKube {
    private AlmostKube() {
    }

    @Nullable
    public static String getPreferredTagForItem(ItemStack stack) {
        TagKey<Item> tag = AlmostUnified.getRuntime().getUnifyLookup().getPreferredTagForItem(AlmostKube.getId(stack));
        return tag == null ? null : tag.location().toString();
    }

    public static ItemStack getReplacementForItem(ItemStack stack) {
        ResourceLocation replacement = AlmostUnified.getRuntime().getUnifyLookup().getReplacementForItem(AlmostKube.getId(stack));
        return ((Item)BuiltInRegistries.ITEM.get(replacement)).getDefaultInstance();
    }

    public static ItemStack getPreferredItemForTag(ResourceLocation tag) {
        TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag);
        ResourceLocation item = AlmostUnified.getRuntime().getUnifyLookup().getPreferredItemForTag((TagKey<Item>)tagKey);
        return ((Item)BuiltInRegistries.ITEM.get(item)).getDefaultInstance();
    }

    public static Set<String> getTags() {
        return AlmostUnified.getRuntime().getTagMap().getTags().stream().map(tag -> tag.location().toString()).collect(Collectors.toSet());
    }

    public static Set<String> getItemIds(ResourceLocation tag) {
        TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag);
        return AlmostUnified.getRuntime().getTagMap().getEntriesByTag((TagKey<Item>)tagKey).stream().map(ResourceLocation::toString).collect(Collectors.toSet());
    }

    public static Collection<? extends UnifyHandler> getUnifyHandlers() {
        return AlmostUnified.getRuntime().getUnifyHandlers();
    }

    @Nullable
    public static UnifyHandler getUnifyHandler(String name) {
        return AlmostUnified.getRuntime().getUnifyHandler(name);
    }

    private static ResourceLocation getId(ItemStack stack) {
        return BuiltInRegistries.ITEM.getResourceKey((Object)stack.getItem()).map(ResourceKey::location).orElseThrow(() -> new IllegalArgumentException("Item not found in registry"));
    }
}

