/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.ClientTagUpdateEvent;
import com.almostreliable.unified.ItemHider;
import com.almostreliable.unified.compat.RecipeIndicator;
import com.almostreliable.unified.recipe.CRTLookup;
import com.almostreliable.unified.recipe.ClientRecipeTracker;
import com.almostreliable.unified.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.category.extension.CategoryExtensionProvider;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;

public class AlmostREI
implements REIClientPlugin {
    @Nullable
    private BasicFilteringRule.MarkDirty filterUpdate;

    public AlmostREI() {
        ClientTagUpdateEvent.register(() -> {
            if (this.filterUpdate != null) {
                this.filterUpdate.markDirty();
            }
        });
    }

    public String getPluginProviderName() {
        return Utils.prefix("roughlyenoughitems");
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        this.filterUpdate = rule.hide(() -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (Holder itemHolder : BuiltInRegistries.ITEM.getTagOrEmpty(ItemHider.HIDE_TAG)) {
                items.add(new ItemStack(itemHolder));
            }
            return EntryIngredients.ofItemStacks(items);
        });
    }

    public void postStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        if (stage != ReloadStage.END || !manager.equals((Object)PluginManager.getClientInstance())) {
            return;
        }
        CategoryRegistry.getInstance().forEach(category -> {
            IndicatorExtension extension = new IndicatorExtension(category.getPlusButtonArea().orElse(null));
            category.registerExtension((CategoryExtensionProvider)Utils.cast(extension));
        });
    }

    private record IndicatorExtension(@Nullable ButtonArea plusButtonArea) implements CategoryExtensionProvider<Display>
    {
        public DisplayCategoryView<Display> provide(Display display, DisplayCategory<Display> category, DisplayCategoryView<Display> lastView) {
            return display.getDisplayLocation().map(CRTLookup::getLink).map(link -> new IndicatorView(lastView, (ClientRecipeTracker.ClientRecipeLink)link)).orElse(lastView);
        }

        private final class IndicatorView
        implements DisplayCategoryView<Display> {
            private final DisplayCategoryView<Display> lastView;
            private final ClientRecipeTracker.ClientRecipeLink link;

            private IndicatorView(DisplayCategoryView<Display> lastView, ClientRecipeTracker.ClientRecipeLink link) {
                this.lastView = lastView;
                this.link = link;
            }

            public DisplayRenderer getDisplayRenderer(Display display) {
                return this.lastView.getDisplayRenderer(display);
            }

            public List<Widget> setupDisplay(Display display, Rectangle bounds) {
                int size;
                int pY;
                int pX;
                if (IndicatorExtension.this.plusButtonArea != null) {
                    Rectangle area = IndicatorExtension.this.plusButtonArea.get(bounds);
                    pX = area.x;
                    pY = area.y - area.height - 2;
                    size = area.width;
                } else {
                    pX = bounds.x - 5;
                    pY = bounds.y - 5;
                    size = 10;
                }
                List widgets = this.lastView.setupDisplay(display, bounds);
                widgets.add(Widgets.createDrawableWidget((guiGraphics, mX, mY, delta) -> RecipeIndicator.renderIndicator(guiGraphics, pX, pY, size)));
                Rectangle tooltipArea = new Rectangle(pX, pY, size, size);
                widgets.add(Widgets.createTooltip((Rectangle)tooltipArea, RecipeIndicator.constructTooltip(this.link)));
                return widgets;
            }
        }
    }
}

