/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.api.recipe.RecipeJson;
import com.almostreliable.unified.api.recipe.RecipeUnifier;
import com.almostreliable.unified.recipe.unifier.GenericRecipeUnifier;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;

public class GregTechModernRecipeUnifier
implements RecipeUnifier {
    private static final String CONTENT = "content";

    @Override
    public void unifyItems(RecipeContext context, RecipeJson recipe) {
        GenericRecipeUnifier.INSTANCE.unifyItems(context, recipe);
        this.doUnify(recipe, "inputs", context::unifyBasicInput);
        this.doUnify(recipe, "tickInputs", context::unifyBasicInput);
        this.doUnify(recipe, "outputs", json -> context.unifyBasicOutput((JsonObject)json, true, "item", "ingredient"));
        this.doUnify(recipe, "tickOutputs", json -> context.unifyBasicOutput((JsonObject)json, true, "item", "ingredient"));
    }

    public void doUnify(RecipeJson recipe, String key, Function<JsonObject, Boolean> callback) {
        JsonElement property = recipe.getProperty(key);
        if (property == null) {
            return;
        }
        JsonElement jsonElement = property.getAsJsonObject().get("item");
        if (!(jsonElement instanceof JsonArray)) {
            return;
        }
        JsonArray arr = (JsonArray)jsonElement;
        for (JsonElement element : arr) {
            JsonObject content;
            JsonElement jsonElement2 = element.getAsJsonObject().get(CONTENT);
            if (!(jsonElement2 instanceof JsonObject) || !callback.apply(content = (JsonObject)jsonElement2).booleanValue()) continue;
            recipe.markChanged();
        }
    }
}

