/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.api.recipe.RecipeJson;
import com.almostreliable.unified.api.recipe.RecipeUnifier;
import com.almostreliable.unified.recipe.unifier.GenericRecipeUnifier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;

public class ImmersiveEngineeringRecipeUnifier
implements RecipeUnifier {
    private static final String BASE_INGREDIENT = "base_ingredient";

    @Override
    public void unifyItems(RecipeContext context, RecipeJson recipe) {
        GenericRecipeUnifier.INSTANCE.unifyItems(context, recipe);
        List.of("input0", "input1", "input", "additives", "catalyst").forEach(key -> this.unifyInputs(context, recipe, (String)key));
        List.of("result", "results", "slag").forEach(key -> context.unifyOutputs(recipe, (String)key, true, "item", BASE_INGREDIENT));
        this.unifySecondaries(context, recipe);
    }

    public void unifyInputs(RecipeContext context, RecipeJson recipe, String key) {
        JsonObject json;
        JsonElement jsonElement = recipe.getProperty(key);
        if (jsonElement instanceof JsonObject && (json = (JsonObject)jsonElement).has(BASE_INGREDIENT) && context.unifyBasicInput(json.get(BASE_INGREDIENT))) {
            recipe.markChanged();
            return;
        }
        context.unifyInputs(recipe, key);
    }

    public void unifySecondaries(RecipeContext context, RecipeJson recipe) {
        JsonElement secondaries = recipe.getProperty("secondaries");
        if (secondaries == null) {
            return;
        }
        if (context.unifyBasicOutput(secondaries.getAsJsonArray(), true, "output")) {
            recipe.markChanged();
        }
    }
}

