/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.api.recipe.RecipeJson;
import com.almostreliable.unified.api.recipe.RecipeUnifier;
import com.almostreliable.unified.recipe.unifier.GenericRecipeUnifier;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class IntegratedDynamicsRecipeUnifier
implements RecipeUnifier {
    private static final String ITEMS = "items";

    @Override
    public void unifyItems(RecipeContext context, RecipeJson recipe) {
        GenericRecipeUnifier.INSTANCE.unifyItems(context, recipe);
        IntegratedDynamicsRecipeUnifier.unifyItemInput(context, recipe);
        context.unifyOutputs(recipe, "result", true, ITEMS);
        this.unifyItemResult(context, recipe);
    }

    private static void unifyItemInput(RecipeContext context, RecipeJson recipe) {
        JsonElement element = recipe.getProperty("item");
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            JsonObject itemAsObject = new JsonObject();
            itemAsObject.add("item", (JsonElement)primitive);
            if (context.unifyBasicInput((JsonElement)itemAsObject)) {
                recipe.setProperty("item", (JsonElement)itemAsObject);
                return;
            }
        }
        context.unifyInputs(recipe, "item");
    }

    private void unifyItemResult(RecipeContext context, RecipeJson recipe) {
        JsonElement element = recipe.getProperty("result");
        if (!(element instanceof JsonObject)) {
            return;
        }
        JsonObject result = (JsonObject)element;
        JsonElement itemsElement = result.get(ITEMS);
        if (!(itemsElement instanceof JsonArray)) {
            return;
        }
        JsonArray items = (JsonArray)itemsElement;
        if (context.unifyBasicOutput(items, true, "item")) {
            recipe.markChanged();
        }
    }
}

