/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.utils.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Config {
    private final String name;

    public Config(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static <T extends Config> T load(String name, Serializer<T> serializer) {
        AlmostUnified.LOG.info("Loading config: {}", (Object)name);
        JsonObject json = Config.safeLoadJson(name);
        T config = serializer.deserialize(name, json);
        if (serializer.isInvalid()) {
            AlmostUnified.LOG.warn("Config not found or invalid. Creating new config: {}", (Object)((Config)config).getName());
            Config.save(config, serializer);
        }
        return config;
    }

    public static <T extends Config> void save(T config, Serializer<T> serializer) {
        Path filePath = Config.buildPath(Config.createConfigDir(), config.getName());
        Config.save(filePath, config, serializer);
    }

    public static <T extends Config> void save(Path p, T config, Serializer<T> serializer) {
        if (Files.exists(p, new LinkOption[0])) {
            Config.backupConfig(config.getName(), p);
        }
        JsonObject json = serializer.serialize(config);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonString = gson.toJson((JsonElement)json);
        try {
            Files.writeString(p, (CharSequence)jsonString, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            AlmostUnified.LOG.error((Object)e);
        }
    }

    private static void backupConfig(String name, Path p) {
        AlmostUnified.LOG.warn("Config {} is invalid. Backing up and recreating.", (Object)name);
        Path backupPath = p.resolveSibling(p.getFileName() + ".bak");
        try {
            Files.deleteIfExists(backupPath);
            Files.move(p, backupPath, new CopyOption[0]);
        }
        catch (IOException e) {
            AlmostUnified.LOG.error("Could not backup config file", (Throwable)e);
        }
    }

    public static JsonObject safeLoadJson(String file) {
        JsonObject jsonObject;
        block8: {
            Path p = Config.createConfigDir();
            BufferedReader reader = Files.newBufferedReader(Config.buildPath(p, file));
            try {
                jsonObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    AlmostUnified.LOG.warn((Object)ex);
                    return new JsonObject();
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    public static Path createConfigDir() {
        Path p = AlmostUnifiedPlatform.INSTANCE.getConfigPath();
        try {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            AlmostUnified.LOG.error("Failed to create config directory", (Throwable)e);
        }
        return p;
    }

    private static Path buildPath(Path p, String name) {
        return p.resolve(name + ".json");
    }

    public static abstract class Serializer<T extends Config> {
        private boolean valid = true;

        protected void setInvalid() {
            this.valid = false;
        }

        public boolean isInvalid() {
            return !this.valid;
        }

        public <V> V safeGet(Supplier<V> supplier, V defaultValue) {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                this.setInvalid();
                return defaultValue;
            }
        }

        protected Set<Pattern> deserializePatterns(JsonObject json, String configKey, List<String> defaultValue) {
            return this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(configKey)).stream().map(Pattern::compile).collect(Collectors.toSet()), new HashSet<Pattern>(defaultValue.stream().map(Pattern::compile).toList()));
        }

        protected void serializePatterns(JsonObject json, String configKey, Set<Pattern> patterns) {
            json.add(configKey, (JsonElement)JsonUtils.toArray(patterns.stream().map(Pattern::pattern).toList()));
        }

        public abstract T deserialize(String var1, JsonObject var2);

        public abstract JsonObject serialize(T var1);
    }
}

