/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.api.TagMap;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.utils.FileUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.StringUtils;

public class DebugConfig
extends Config {
    public static final String NAME = "debug";
    public final boolean dumpTagMap;
    public final boolean dumpDuplicates;
    public final boolean dumpUnification;
    public final boolean dumpOverview;
    public final boolean dumpRecipes;

    public DebugConfig(String name, boolean dumpTagMap, boolean dumpDuplicates, boolean dumpUnification, boolean dumpOverview, boolean dumpRecipes) {
        super(name);
        this.dumpTagMap = dumpTagMap;
        this.dumpDuplicates = dumpDuplicates;
        this.dumpUnification = dumpUnification;
        this.dumpOverview = dumpOverview;
        this.dumpRecipes = dumpRecipes;
    }

    public void logUnifyTagDump(TagMap<Item> tagMap) {
        if (!this.dumpTagMap) {
            return;
        }
        FileUtils.write(AlmostUnifiedPlatform.INSTANCE.getLogPath(), "unify_tag_dump.txt", sb -> sb.append(tagMap.getTags().stream().sorted(Comparator.comparing(t -> t.location().toString())).map(t -> StringUtils.rightPad((String)t.location().toString(), (int)40) + " => " + tagMap.getEntriesByTag((TagKey<Item>)t).stream().map(ResourceLocation::toString).sorted().collect(Collectors.joining(", ")) + "\n").collect(Collectors.joining())));
    }

    public void logRecipes(Map<ResourceLocation, JsonElement> recipes, String filename) {
        if (!this.dumpRecipes) {
            return;
        }
        FileUtils.write(AlmostUnifiedPlatform.INSTANCE.getLogPath(), filename, sb -> recipes.forEach((key, value) -> sb.append(key.toString()).append(" [JSON]:").append(value.toString()).append("\n")));
    }

    public static class Serializer
    extends Config.Serializer<DebugConfig> {
        public static final String DUMP_TAG_MAP = "dumpTagMap";
        public static final String DUMP_DUPLICATES = "dumpDuplicates";
        public static final String DUMP_UNIFICATION = "dumpUnification";
        public static final String DUMP_OVERVIEW = "dumpOverview";
        public static final String DUMP_RECIPES = "dumpRecipes";

        @Override
        public DebugConfig deserialize(String name, JsonObject json) {
            return new DebugConfig(name, this.safeGet(() -> json.get(DUMP_TAG_MAP).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_DUPLICATES).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_UNIFICATION).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_OVERVIEW).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_RECIPES).getAsBoolean(), false));
        }

        @Override
        public JsonObject serialize(DebugConfig src) {
            JsonObject json = new JsonObject();
            json.addProperty(DUMP_TAG_MAP, Boolean.valueOf(src.dumpTagMap));
            json.addProperty(DUMP_DUPLICATES, Boolean.valueOf(src.dumpDuplicates));
            json.addProperty(DUMP_UNIFICATION, Boolean.valueOf(src.dumpUnification));
            json.addProperty(DUMP_OVERVIEW, Boolean.valueOf(src.dumpOverview));
            json.addProperty(DUMP_RECIPES, Boolean.valueOf(src.dumpRecipes));
            return json;
        }
    }
}

